/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.loader.parser.FieldValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.ParameterModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.loader.parser.ValueProviderModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.InputResolverModelParser;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * Common configurations for parameters. Removes duplicated code and appeases the SonarQube report.
 */
public interface ParameterModelParserWithDefaults extends ParameterModelParser {

  @Override
  default Object getDefaultValue() {
    // Returning null as parameters in interpreted connectivity connectors do not have default values.
    return null;
  }

  @Override
  default Optional<LayoutModel> getLayoutModel() {
    return Optional.empty();
  }

  @Override
  default Optional<ParameterDslConfiguration> getDslConfiguration() {
    return Optional.empty();
  }

  @Override
  default Optional<ValueProviderModelParser> getValueProviderModelParser() {
    return Optional.empty();
  }

  @Override
  default List<FieldValueProviderModelParser> getFieldValueProvidersModelParser() {
    return List.of();
  }

  @Override
  default boolean isExcludedFromConnectivitySchema() {
    // Parameters are included in the connectivity schema to enable proper tooling support
    // and configuration validation in Studio and other development tools.
    return false;
  }

  @Override
  default boolean isConfigOverride() {
    // Parameters are not configuration overrides because interpreted connectivity parameters
    // are regular connection configuration parameters rather than overrides of global settings.
    return false;
  }

  @Override
  default boolean isComponentId() {
    // Parameters are not component identifiers because interpreted connectivity parameters
    // are configuration values rather than identifiers used for component lookup or referencing.
    return false;
  }

  @Override
  default Optional<DeprecationModel> getDeprecationModel() {
    return Optional.empty();
  }

  @Override
  default Optional<DisplayModel> getDisplayModel() {
    return Optional.empty();
  }

  @Override
  default Optional<OAuthParameterModelProperty> getOAuthParameterModelProperty() {
    return Optional.empty();
  }

  @Override
  default Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
    return Optional.empty();
  }

  @Override
  default Optional<InputResolverModelParser> getInputResolverModelParser() {
    return Optional.empty();
  }

  @Override
  default Optional<Pair<Integer, Boolean>> getMetadataKeyPart() {
    return Optional.empty();
  }

  @Override
  default List<ModelProperty> getAdditionalModelProperties() {
    return List.of();
  }

  @Override
  default List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory stereotypeModelFactory) {
    return List.of();
  }

  @Override
  default Set<String> getSemanticTerms() {
    return Set.of();
  }
}
