/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.parser;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import static org.mule.runtime.api.meta.model.parameter.ParameterRole.BEHAVIOUR;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TlsParser implements ParameterModelParserWithDefaults {

  private final InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType tlsContextInfrastructureType;
  private final MetadataType tlsContextType;
  private static final String DISPLAY_NAME = "TLS Configuration";

  public TlsParser() {
    this.tlsContextInfrastructureType = InfrastructureTypeUtils.getMetadataTypeBasedInfrastructureType(TlsContextFactory.class);
    this.tlsContextType = new DefaultExtensionsTypeLoaderFactory()
        .createTypeLoader(TlsParser.class.getClassLoader())
        .load(TlsContextFactory.class);

  }

  @Override
  public String getName() {
    return tlsContextInfrastructureType.getName();
  }

  @Override
  public String getDescription() {
    return "";
  }

  @Override
  public MetadataType getType() {
    return tlsContextType;
  }

  @Override
  public boolean isRequired() {
    return false;
  }

  @Override
  public ParameterRole getRole() {
    return BEHAVIOUR;
  }

  @Override
  public ExpressionSupport getExpressionSupport() {
    return NOT_SUPPORTED;
  }

  @Override
  public Optional<LayoutModel> getLayoutModel() {
    return Optional.ofNullable(LayoutModel.builder().tabName(Placement.SECURITY_TAB).build());
  }

  @Override
  public Optional<ParameterDslConfiguration> getDslConfiguration() {
    return tlsContextInfrastructureType.getDslConfiguration();
  }

  @Override
  public List<ModelProperty> getAdditionalModelProperties() {
    List<ModelProperty> modelProperties = new ArrayList<>();
    modelProperties.add(new SyntheticModelModelProperty());
    modelProperties.add(new InfrastructureParameterModelProperty(tlsContextInfrastructureType.getSequence()));
    tlsContextInfrastructureType.getQNameModelProperty().ifPresent(modelProperties::add);
    return Collections.unmodifiableList(modelProperties);
  }

  @Override
  public Optional<DisplayModel> getDisplayModel() {
    return Optional.ofNullable(DisplayModel.builder()
        .displayName(DISPLAY_NAME)
        .build());
  }
}
