/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractOAuth2ConnectivityConnectionProvider extends BaseConnectivityConnectionProvider {

  private static final String BASE_URI_PARAM = "baseUri";
  private static final String ACCESS_TOKEN_PARAM = "accessToken";

  private String baseUri;

  public AbstractOAuth2ConnectivityConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
    super(connectionProviderModel);
  }

  @Override
  public Map<String, Object> getParameters() {
    Map<String, Object> params = new HashMap<>();
    params.put(BASE_URI_PARAM, baseUri);
    params.put(ACCESS_TOKEN_PARAM, getAccessToken());
    return params;
  }

  protected abstract String getAccessToken();
}
