/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;

import java.util.Map;

/**
 * Provides a Bearer Connection Provider params for authentication.
 */
public class BearerConnectivityConnectionProvider extends BaseConnectivityConnectionProvider {

  private static final String BASEURI_PARAM = "baseUri";
  private static final String TOKEN_PARAM = "token";

  // Injected by mule
  private String baseUri;
  private String token;

  /**
   * Enhanced constructor that sets up validation with the provided models.
   *
   * @param connectionProviderModel the connection provider model
   */
  public BearerConnectivityConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
    super(connectionProviderModel);
  }

  @Override
  public Map<String, Object> getParameters() {
    return Map.of(BASEURI_PARAM, baseUri,
                  TOKEN_PARAM, token);
  }
}
