/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;

/**
 * Provides an OAuth Cc Connection Provider params for authentication.
 */
public class OAuth2ClientCredentialsConnectionProvider extends AbstractOAuth2ConnectivityConnectionProvider {

  private ClientCredentialsState clientCredentialsState;

  public OAuth2ClientCredentialsConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
    super(connectionProviderModel);
  }

  @Override
  protected String getAccessToken() {
    return clientCredentialsState.getAccessToken();
  }
}
