/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.api.loader;

import static java.util.Collections.singleton;

import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoaderProvider;
import org.mule.runtime.extension.ic.internal.loader.ConnectivityExtensionModelLoader;

import java.util.Set;

/*
 * Provides an implementation of the {@link ExtensionModelLoaderProvider} interface
 * for loading extension models specific to interpreted connectivity.
 */
public class ConnectivityExtensionModelLoaderProvider implements ExtensionModelLoaderProvider {

  @Override
  public Set<ExtensionModelLoader> getExtensionModelLoaders() {
    return singleton(new ConnectivityExtensionModelLoader());
  }
}
