/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;

import java.util.Map;

/**
 * Provides an API Key Connection Provider params for authentication.
 */
public class APIKeyConnectivityConnectionProvider extends BaseConnectivityConnectionProvider {

  private static final String BASEURI_PARAM = "baseUri";
  private static final String APIKEY_PARAM = "apiKey";

  // Injected by mule
  private String baseUri;
  private String apiKey;

  /**
   * Enhanced constructor that sets up validation with the provided models.
   *
   * @param connectionProviderModel the connection provider model
   */
  public APIKeyConnectivityConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
    super(connectionProviderModel);
  }

  @Override
  public Map<String, Object> getParameters() {
    return Map.of(BASEURI_PARAM, baseUri,
                  APIKEY_PARAM, apiKey);
  }
}
