/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;

import java.util.Map;

/**
 * Provides a Basic Connection Provider params for authentication.
 */
public class BasicConnectivityConnectionProvider extends BaseConnectivityConnectionProvider {


  private static final String BASEURI_PARAM = "baseUri";
  private static final String USERNAME_PARAM = "username";
  private static final String PASSWORD_PARAM = "password";

  // Injected by mule
  private String baseUri;
  private String username;
  private String password;

  /**
   * Enhanced constructor that sets up validation with the provided models.
   *
   * @param connectionProviderModel the connection provider model
   */
  public BasicConnectivityConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
    super(connectionProviderModel);
  }

  @Override
  public Map<String, Object> getParameters() {
    return Map.of(BASEURI_PARAM, baseUri,
                  USERNAME_PARAM, username,
                  PASSWORD_PARAM, password);
  }
}
