/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;

/**
 * Provides an OAuth Ac Connection Provider params for authentication.
 */
public class OAuth2AuthorizationCodeConnectionProvider extends AbstractOAuth2ConnectivityConnectionProvider {

  private AuthorizationCodeState authorizationCodeState;

  public OAuth2AuthorizationCodeConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
    super(connectionProviderModel);
  }

  @Override
  protected String getAccessToken() {
    return authorizationCodeState.getAccessToken();
  }
}
