/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.runtime.operation;

import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;

import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;

import java.util.Map;

public class OperationExecutorFactory implements CompletableComponentExecutorFactory<OperationModel> {

  private final MuleOperationSerializableModel model;

  public OperationExecutorFactory(MuleOperationSerializableModel model) {
    this.model = model;
  }

  @Override
  public CompletableComponentExecutor<OperationModel> createExecutor(OperationModel operationModel, Map<String, Object> map) {
    return new OperationExecutor(model);
  }
}
