/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.runtime.extension.ic.internal.utils;

public class StringUtils {

  private StringUtils() {}

  /**
   * Checks if the kind string is null or empty.
   *
   * @param kind the kind string to check
   * @return true if the kind is null or empty, false otherwise
   */
  public static boolean isNullOrEmpty(String kind) {
    return kind == null || kind.trim().isEmpty();
  }
}
