/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class ConnectivityException
extends ModuleException
implements ErrorMessageAwareException {
    private final Message message;

    public ConnectivityException(ErrorTypeDefinition<?> errorTypeDefinition, String errorMessage, Result<Object, Object> errorResult) {
        super(errorMessage, errorTypeDefinition);
        Message.Builder builder = Message.builder().payload(this.getPayloadTypedValue(errorResult)).mediaType(this.getMediaType(errorResult));
        this.setAttributes(errorResult, builder);
        this.message = builder.build();
    }

    private TypedValue<Object> getPayloadTypedValue(Result<Object, Object> response) {
        if (response.getOutput() == null) {
            return TypedValue.of(null);
        }
        DataType dataType = DataType.builder().type(response.getOutput().getClass()).mediaType(this.getMediaType(response)).build();
        return new TypedValue(response.getOutput(), dataType, response.getByteLength());
    }

    private void setAttributes(Result<Object, Object> errorResult, Message.Builder builder) {
        errorResult.getAttributes().ifPresent(attributes -> {
            DataType dataType = DataType.builder().type(attributes.getClass()).mediaType(errorResult.getAttributesMediaType().orElse(MediaType.APPLICATION_JAVA)).build();
            builder.attributes(new TypedValue(attributes, dataType));
        });
    }

    private MediaType getMediaType(Result<Object, Object> response) {
        return response.getMediaType().orElse(MediaType.APPLICATION_JSON);
    }

    public Message getErrorMessage() {
        return this.message;
    }
}

