/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.operation.pagination;

import com.mulesoft.connectivity.mule.api.Content;
import com.mulesoft.connectivity.mule.api.Page;
import com.mulesoft.connectivity.mule.api.operation.OperationResult;
import com.mulesoft.connectivity.mule.api.operation.ResultError;
import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.ic.internal.runtime.connection.Connection;
import org.mule.runtime.extension.ic.internal.utils.ContentExtractorUtils;
import org.mule.runtime.extension.ic.internal.utils.StreamingParameterUtils;
import org.mule.runtime.extension.ic.internal.utils.StreamingUtils;

public class ConnectivityPagingProvider
implements PagingProvider<Connection, TypedValue<String>> {
    private final ExecutionContext<OperationModel> executionContext;
    private final MuleOperationSerializableModel model;
    private OperationResult<Page<?>> pageOperationResult = null;
    @Inject
    private ExpressionLanguage expressionLanguage;

    public ConnectivityPagingProvider(ExecutionContext<OperationModel> executionContext, MuleOperationSerializableModel muleOperationSerializableModel) {
        this.executionContext = executionContext;
        this.model = muleOperationSerializableModel;
    }

    public List<TypedValue<String>> getPage(Connection connection) {
        ConnectionProvider provider = (ConnectionProvider)this.executionContext.getConfiguration().flatMap(ConfigurationInstance::getConnectionProvider).orElseThrow();
        try {
            Connection connectionProvider = (Connection)provider.connect();
            if (this.pageOperationResult == null) {
                Map<String, Object> resolvedParameters = StreamingParameterUtils.resolveStreamingParameters(this.executionContext.getParameters(), this.expressionLanguage);
                this.pageOperationResult = connectionProvider.executeOperation(this.model, resolvedParameters).map(p -> (Page)p);
            } else {
                if (!this.hasNextPage(this.pageOperationResult)) {
                    return List.of();
                }
                this.pageOperationResult = connectionProvider.executeOperationNextPage(this.model, ((Page)this.pageOperationResult.getValue()).getNextPage().orElseThrow()).map(p -> (Page)p);
            }
            return this.transformToResult(this.pageOperationResult);
        }
        catch (Exception e) {
            String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)errorMessage), e.getCause());
        }
    }

    public Optional<Integer> getTotalResults(Connection connection) {
        return Optional.empty();
    }

    public void close(Connection connection) throws MuleException {
    }

    private boolean hasNextPage(OperationResult<? extends Page<?>> pageResult) {
        return ((Page)pageResult.getValue()).getNextPage().isPresent();
    }

    private List<TypedValue<String>> transformToResult(OperationResult<Page<?>> pageOperationResult) {
        if (!pageOperationResult.isSuccess()) {
            ResultError errorValue = Connection.getErrorCauseIfUncheckedError(pageOperationResult.getErrorValue());
            throw new RuntimeException("Failed to extract the result of the operation: " + String.valueOf(errorValue) + System.lineSeparator() + "Cause: " + String.valueOf(errorValue.getDescription()) + System.lineSeparator());
        }
        List items = ((Page)pageOperationResult.getValue()).getItems();
        ArrayList<TypedValue<String>> resultList = new ArrayList<TypedValue<String>>();
        for (Object item : items) {
            MediaType mediaType = ContentExtractorUtils.getMediaType((Content)item);
            InputStream stream = ContentExtractorUtils.getRawValue((Content)item);
            Charset charset = mediaType.getCharset().orElse(Charset.defaultCharset());
            resultList.add(StreamingUtils.consumeStreamAndClose(stream, mediaType, charset));
        }
        return resultList;
    }
}

