/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.parser;

import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.loader.parser.BackPressureModeParser;
import org.mule.runtime.extension.api.loader.parser.OutputModelParser;
import org.mule.runtime.extension.api.loader.parser.SourceModelParser;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.SdkSourceFactory;
import org.mule.runtime.extension.api.runtime.source.SourceFactoryContext;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityExecutableModelParser;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityOutputModelParser;
import org.mule.runtime.extension.ic.internal.parser.utils.AnnotationUtils;
import org.mule.runtime.extension.ic.internal.runtime.source.ConnectivityPollingSource;
import org.mule.sdk.api.runtime.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivitySourceModelParser
extends ConnectivityExecutableModelParser<MuleSourceSerializableModel>
implements SourceModelParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConnectivitySourceModelParser.class);

    public ConnectivitySourceModelParser(MuleConnectorSerializableModel connectorModel, MuleSourceSerializableModel sourceModel) {
        super(connectorModel, sourceModel);
        if (!(sourceModel.getInputType() instanceof ObjectType)) {
            throw new IllegalArgumentException("The input type for mule sources cannot be a non-object type");
        }
    }

    public OutputModelParser getOutputType() {
        return new ConnectivityOutputModelParser(((MuleSourceSerializableModel)this.model).getOutputType(), false);
    }

    public OutputModelParser getAttributesOutputType() {
        return new ConnectivityOutputModelParser((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build(), false);
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnSuccessCallbackParser() {
        return Optional.empty();
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnErrorCallbackParser() {
        return Optional.empty();
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnTerminateCallbackParser() {
        return Optional.empty();
    }

    public Optional<SourceModelParser.SourceCallbackModelParser> getOnBackPressureCallbackParser() {
        return Optional.empty();
    }

    public boolean isPolling() {
        return true;
    }

    public Optional<SdkSourceFactory> getSourceFactory() {
        Optional<SdkSourceFactory> maybeSourceFactory = ((MuleSourceSerializableModel)this.model).getModelReference().map(modelReference -> new SdkSourceFactory(){

            public Either<Source, org.mule.runtime.extension.api.runtime.source.Source> createMessageSource() {
                throw new UnsupportedOperationException("UC does not support building mule sources without a SourceFactoryContext");
            }

            public org.mule.runtime.extension.api.runtime.source.Source<?, ?> createMessageSource(SourceFactoryContext ctx) {
                return new ConnectivityPollingSource(ctx, (MuleSourceSerializableModel)ConnectivitySourceModelParser.this.model);
            }
        });
        if (maybeSourceFactory.isEmpty()) {
            LOGGER.error("Skipping {} since it lacks a model reference", (Object)((MuleSourceSerializableModel)this.model).getName());
        }
        return maybeSourceFactory;
    }

    public boolean emitsResponse() {
        return false;
    }

    public boolean supportsStreaming() {
        return false;
    }

    public Optional<DisplayModel> getDisplayModel() {
        DisplayModel displayModel = DisplayModel.builder().displayName(((MuleSourceSerializableModel)this.model).getDisplayName()).build();
        return Optional.of(displayModel);
    }

    public Optional<BackPressureModeParser> getBackPressureModeParser() {
        return Optional.of(new BackPressureModeParser(){

            public BackPressureMode getDefaultMode() {
                return BackPressureMode.WAIT;
            }

            public Set<BackPressureMode> getSupportedModes() {
                return Set.of(BackPressureMode.WAIT);
            }
        });
    }

    public Optional<SourceClusterSupport> getSourceClusterSupport() {
        return Optional.of(SourceClusterSupport.DEFAULT_ALL_NODES);
    }

    public Set<String> getSemanticTerms() {
        return AnnotationUtils.getSemanticTerms(((MuleSourceSerializableModel)this.model).getInputType().getAnnotations());
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return List.of();
    }
}

