/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import com.mulesoft.connectivity.mule.persistence.model.MuleErrorSerializableModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.extension.ic.internal.error.ErrorMapper;
import org.mule.runtime.extension.ic.internal.parser.ConnectivityErrorModelParser;
import org.mule.runtime.extension.ic.internal.utils.StringUtils;

public class ConnectivityErrorModelParserFactory {
    private static final boolean IS_MULE_ERROR = true;
    private static final boolean IS_NOT_MULE_ERROR = false;
    private static final boolean IS_NOT_SUPPRESSED = false;

    private ConnectivityErrorModelParserFactory() {
    }

    public static List<ConnectivityErrorModelParser> createErrorModelParsers(List<MuleErrorSerializableModel> errorModels, String extensionNamespace) {
        if (errorModels == null || errorModels.isEmpty()) {
            return List.of();
        }
        ArrayList<ConnectivityErrorModelParser> errorModelParsers = new ArrayList<ConnectivityErrorModelParser>();
        LinkedHashSet<String> seenErrorTypes = new LinkedHashSet<String>();
        for (MuleErrorSerializableModel errorModel : errorModels) {
            ConnectivityErrorModelParser errorParser = ConnectivityErrorModelParserFactory.createErrorModelParserFromModel(errorModel, extensionNamespace);
            if (errorParser == null || !seenErrorTypes.add(errorParser.getType())) continue;
            errorModelParsers.add(errorParser);
        }
        return errorModelParsers;
    }

    private static ConnectivityErrorModelParser createErrorModelParserFromModel(MuleErrorSerializableModel errorModel, String extensionNamespace) {
        ConnectivityErrorModelParser rootAnyErrorParser = ConnectivityErrorModelParserFactory.createErrorModelParser("ANY", "MULE", true, null);
        String kind = errorModel.getKind();
        if (StringUtils.isNullOrEmpty(kind)) {
            return rootAnyErrorParser;
        }
        return switch (kind) {
            case "status-unexpected", "status-default" -> rootAnyErrorParser;
            case "status-unauthorized" -> ConnectivityErrorModelParserFactory.createUnauthorizedErrorModelParser(extensionNamespace, rootAnyErrorParser);
            case "status-4xx" -> ConnectivityErrorModelParserFactory.createErrorModelParser("CLIENT_ERROR", extensionNamespace, false, rootAnyErrorParser);
            case "status-5xx" -> ConnectivityErrorModelParserFactory.createErrorModelParser("SERVER_ERROR", extensionNamespace, false, rootAnyErrorParser);
            default -> ConnectivityErrorModelParserFactory.createErrorModelParserWithHierarchy(kind, errorModel.getCategories(), extensionNamespace, rootAnyErrorParser);
        };
    }

    private static ConnectivityErrorModelParser createUnauthorizedErrorModelParser(String extensionNamespace, ConnectivityErrorModelParser rootAnyErrorParser) {
        ConnectivityErrorModelParser securityParser = ConnectivityErrorModelParserFactory.createErrorModelParser("SECURITY", "MULE", true, rootAnyErrorParser);
        return ConnectivityErrorModelParserFactory.createErrorModelParser("UNAUTHORIZED", extensionNamespace, false, securityParser);
    }

    private static ConnectivityErrorModelParser createErrorModelParser(String errorType, String namespace, boolean isMuleError, ConnectivityErrorModelParser parent) {
        return new ConnectivityErrorModelParser(errorType, namespace, isMuleError, false, parent);
    }

    private static ConnectivityErrorModelParser createErrorModelParserWithHierarchy(String kind, List<String> categories, String extensionNamespace, ConnectivityErrorModelParser rootAnyErrorParser) {
        String errorTypeName = ErrorMapper.getErrorTypeNameByKind(kind);
        if (StringUtils.isNullOrEmpty(errorTypeName)) {
            return rootAnyErrorParser;
        }
        List<String> errorTypeNameHierarchyExcludingANY = ConnectivityErrorModelParserFactory.prepareErrorNameHierarchy(categories, errorTypeName);
        return ConnectivityErrorModelParserFactory.prepareErrorModelParserFromHierarchy(errorTypeNameHierarchyExcludingANY, extensionNamespace, rootAnyErrorParser);
    }

    private static ConnectivityErrorModelParser prepareErrorModelParserFromHierarchy(List<String> errorTypeNameHierarchyExcludingRoot, String extensionNamespace, ConnectivityErrorModelParser rootAnyErrorParser) {
        ConnectivityErrorModelParser currentParent = rootAnyErrorParser;
        for (String errorTypeName : errorTypeNameHierarchyExcludingRoot) {
            ConnectivityErrorModelParser currentParser;
            currentParent = currentParser = ConnectivityErrorModelParserFactory.createErrorModelParser(errorTypeName, extensionNamespace, false, currentParent);
        }
        return currentParent;
    }

    private static List<String> prepareErrorNameHierarchy(List<String> categories, String errorTypeName) {
        LinkedList<String> errorTypeNameHierarchyList = new LinkedList<String>();
        if (ConnectivityErrorModelParserFactory.areCategoriesNotValid(categories, errorTypeName)) {
            return errorTypeNameHierarchyList;
        }
        errorTypeNameHierarchyList.addFirst(errorTypeName);
        for (String category : categories) {
            errorTypeNameHierarchyList.addFirst(category);
        }
        return errorTypeNameHierarchyList;
    }

    private static boolean areCategoriesNotValid(List<String> categories, String errorTypeName) {
        LinkedHashSet<String> uniqueCategories = new LinkedHashSet<String>();
        for (String category : categories) {
            if (!"ANY".equals(category) && !errorTypeName.equals(category) && uniqueCategories.add(category)) continue;
            return true;
        }
        return false;
    }
}

