/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.valueProvider;

import com.mulesoft.connectivity.mule.api.Page;
import com.mulesoft.connectivity.mule.api.operation.OperationResult;
import com.mulesoft.connectivity.mule.api.valueprovider.ProvidedValue;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedContextReferenceVariable;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedObjectFieldSelector;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedProviderArgument;
import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedTypeReferenceExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactoryContext;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.extension.ic.internal.runtime.connection.Connection;

public class ValueProviderExecutor
implements ValueProvider {
    public ValueProviderFactoryContext valueProviderFactoryContext;
    private final MuleValueProviderSerializableModel model;
    private final List<SerializedProviderArgument> providerArguments;
    private static final String PROCESSING_FAILURE = "PROCESSING_FAILURE";

    public ValueProviderExecutor(ValueProviderFactoryContext valueProviderFactoryContext, MuleValueProviderSerializableModel model, List<SerializedProviderArgument> providerArguments) {
        this.valueProviderFactoryContext = valueProviderFactoryContext;
        this.model = model;
        this.providerArguments = providerArguments;
    }

    public Set<Value> resolve() throws ValueResolvingException {
        try {
            Map<String, Object> parameters = this.fetchParamValues(this.model);
            Connection connection = this.getConnection();
            List<ProvidedValue> allProvidedValues = this.fetchAllPages(connection, parameters);
            return this.convertToValues(allProvidedValues);
        }
        catch (ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueResolvingException("Failed to resolve values: " + e.getMessage(), PROCESSING_FAILURE);
        }
    }

    private Connection getConnection() {
        return (Connection)((Supplier)this.valueProviderFactoryContext.getConnectionSupplier().orElseThrow()).get();
    }

    private List<ProvidedValue> fetchAllPages(Connection connection, Map<String, Object> parameters) throws ValueResolvingException {
        ArrayList<ProvidedValue> allValues = new ArrayList<ProvidedValue>();
        OperationResult<Page<ProvidedValue>> pageResult = connection.executeValueProvider(this.model, parameters);
        if (pageResult.isSuccess()) {
            allValues.addAll(((Page)pageResult.getValue()).getItems());
        }
        while (pageResult.isSuccess() && this.hasNextPage((Page<ProvidedValue>)((Page)pageResult.getValue()))) {
            if (!(pageResult = this.fetchNextPage(connection, (Serializable)((Page)pageResult.getValue()).getNextPage().orElseThrow())).isSuccess()) continue;
            allValues.addAll(((Page)pageResult.getValue()).getItems());
        }
        if (!pageResult.isSuccess()) {
            throw new ValueResolvingException("Failed to execute operation: " + String.valueOf(pageResult.getErrorValue().getValue()), PROCESSING_FAILURE);
        }
        return allValues;
    }

    private boolean hasNextPage(Page<ProvidedValue> page) {
        return page.getNextPage().isPresent();
    }

    private OperationResult<Page<ProvidedValue>> fetchNextPage(Connection connection, Serializable nextPageToken) {
        return connection.executeValueProviderNextPage(this.model, nextPageToken);
    }

    private Set<Value> convertToValues(List<ProvidedValue> providedValues) {
        return providedValues.stream().map(this::createValue).collect(Collectors.toSet());
    }

    private Value createValue(ProvidedValue providedValue) {
        return ValueBuilder.newValue((String)providedValue.getValue().toString()).withDisplayName(providedValue.getLabel()).build();
    }

    private Map<String, Object> fetchParamValues(MuleValueProviderSerializableModel valueProviderSerializableModel) throws ValueResolvingException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<String> missingRequiredParameters = new ArrayList<String>();
        for (SerializedProviderArgument argument : this.providerArguments) {
            String parameterName = this.getParameterNameFromSelector(argument.getParameterSelector());
            Object parameterValue = this.resolveParameterValueFromInputSelector(argument.getInputSelector());
            if (parameterValue != null && !parameterValue.equals("")) {
                parameters.put(parameterName, parameterValue);
                continue;
            }
            if (!this.isParameterRequired(valueProviderSerializableModel, parameterName)) continue;
            missingRequiredParameters.add(this.getExtractionExpression(argument.getInputSelector()));
        }
        this.validateRequiredParameters(missingRequiredParameters);
        return parameters;
    }

    private void validateRequiredParameters(List<String> missingRequiredParameters) throws ValueResolvingException {
        if (!missingRequiredParameters.isEmpty()) {
            throw new ValueResolvingException("Unable to retrieve values. There are missing required parameters for the resolution: " + String.valueOf(missingRequiredParameters), "MISSING_REQUIRED_PARAMETERS");
        }
    }

    private String getExtractionExpression(SerializedTypeReferenceExpression inputSelector) {
        if (inputSelector instanceof SerializedContextReferenceVariable) {
            SerializedContextReferenceVariable contextVar = (SerializedContextReferenceVariable)inputSelector;
            return contextVar.getName();
        }
        if (inputSelector instanceof SerializedObjectFieldSelector) {
            SerializedObjectFieldSelector objectFieldSelector = (SerializedObjectFieldSelector)inputSelector;
            return String.join((CharSequence)".", objectFieldSelector.getPath());
        }
        throw new RuntimeException("Unknown type reference expression: " + String.valueOf(inputSelector.getClass()));
    }

    private boolean isParameterRequired(MuleValueProviderSerializableModel valueProviderModel, String parameterName) {
        for (ObjectFieldType field : ((DefaultObjectType)valueProviderModel.getInputType()).getFields()) {
            String paramName = field.getKey().getName().toString();
            if (!field.isRequired() || !parameterName.equals(paramName)) continue;
            return true;
        }
        return false;
    }

    private String getParameterNameFromSelector(SerializedObjectFieldSelector parameterSelector) {
        String[] path = parameterSelector.getPath();
        if (path.length == 0) {
            throw new RuntimeException("Invalid parameter Selector");
        }
        return path[0];
    }

    private Object resolveParameterValueFromInputSelector(SerializedTypeReferenceExpression inputSelector) {
        if (inputSelector instanceof SerializedContextReferenceVariable) {
            SerializedContextReferenceVariable contextVar = (SerializedContextReferenceVariable)inputSelector;
            return this.resolveContextVariable(contextVar);
        }
        if (inputSelector instanceof SerializedObjectFieldSelector) {
            SerializedObjectFieldSelector objectFieldSelector = (SerializedObjectFieldSelector)inputSelector;
            return this.resolveObjectFieldSelector(objectFieldSelector);
        }
        throw new RuntimeException("Unknown type reference expression: " + String.valueOf(inputSelector.getClass()));
    }

    private Object resolveContextVariable(SerializedContextReferenceVariable contextVar) {
        return this.valueProviderFactoryContext.getComponentParameterization().getParameter(contextVar.getName(), contextVar.getName());
    }

    private Object resolveObjectFieldSelector(SerializedObjectFieldSelector objectFieldSelector) {
        String[] path = objectFieldSelector.getPath();
        this.validatePath(path);
        Object currentValue = this.getRootParameterValue(path[0]);
        return this.traversePath(currentValue, path);
    }

    private void validatePath(String[] path) {
        if (path.length == 0) {
            throw new RuntimeException("Invalid expression: empty path");
        }
    }

    private Object getRootParameterValue(String rootParameter) {
        try {
            return this.valueProviderFactoryContext.getComponentParameterization().getParameter(rootParameter, rootParameter);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Object traversePath(Object currentValue, String[] path) {
        for (int i = 1; i < path.length; ++i) {
            currentValue = this.traversePathElement(currentValue, path[i]);
        }
        return currentValue;
    }

    private Object traversePathElement(Object currentValue, String pathElement) {
        if (currentValue == null) {
            return null;
        }
        if (currentValue instanceof Map) {
            Map map = (Map)currentValue;
            return map.get(pathElement);
        }
        throw new RuntimeException("Input value is not of type map: " + String.valueOf(currentValue));
    }
}

