/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.ic.internal.error.DynamicErrorTypeDefinition;
import org.mule.runtime.extension.ic.internal.error.ErrorMapper;
import org.mule.runtime.extension.ic.internal.utils.StringUtils;

public class ErrorTypeDefinitionFactory {
    private ErrorTypeDefinitionFactory() {
    }

    public static ErrorTypeDefinition<?> createErrorTypeDefinition(String kind) {
        if (StringUtils.isNullOrEmpty(kind)) {
            return MuleErrors.ANY;
        }
        return switch (kind) {
            case "status-unexpected", "status-default" -> MuleErrors.ANY;
            case "status-unauthorized" -> ErrorTypeDefinitionFactory.createDynamicErrorTypeDefinition("UNAUTHORIZED");
            case "status-4xx" -> ErrorTypeDefinitionFactory.createDynamicErrorTypeDefinition("CLIENT_ERROR");
            case "status-5xx" -> ErrorTypeDefinitionFactory.createDynamicErrorTypeDefinition("SERVER_ERROR");
            default -> ErrorTypeDefinitionFactory.createDefaultErrorTypeDefinition(kind);
        };
    }

    private static ErrorTypeDefinition<?> createDefaultErrorTypeDefinition(String errorName) {
        String errorTypeName = ErrorMapper.getErrorTypeNameByKind(errorName);
        return ErrorTypeDefinitionFactory.createDynamicErrorTypeDefinition(errorTypeName);
    }

    private static ErrorTypeDefinition<?> createDynamicErrorTypeDefinition(String errorName) {
        return new DynamicErrorTypeDefinition(errorName);
    }
}

