/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.loader;

import com.google.gson.Gson;
import com.mulesoft.connectivity.mule.persistence.deserialize.loader.MuleModelDeserializer;
import com.mulesoft.connectivity.mule.persistence.model.MuleConnectorSerializableModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class ConnectorLoaderHandler {
    private static final String URL_ERROR_MESSAGE = "Unable to load the connector metadata. There is no file present in the connector artifact in the path: '%s'";

    private ConnectorLoaderHandler() {
    }

    public static MuleConnectorSerializableModel loadConnectorModel(MuleModelDeserializer muleModelDeserializer, String modulePath) {
        URL resource = ConnectorLoaderHandler.getResourceAsURL(modulePath);
        if (resource == null) {
            throw new IllegalStateException(String.format(URL_ERROR_MESSAGE, modulePath));
        }
        String serializedModel = ConnectorLoaderHandler.getResourceAsString(resource);
        return muleModelDeserializer.deserialize((Map)new Gson().fromJson(serializedModel, Object.class));
    }

    private static String getResourceAsString(URL resource) {
        String string;
        BufferedInputStream resourceIS = new BufferedInputStream(resource.openStream());
        try {
            string = IOUtils.toString((InputStream)resourceIS, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    resourceIS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to process the resource : " + String.valueOf(e));
            }
        }
        resourceIS.close();
        return string;
    }

    private static URL getResourceAsURL(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }
}

