/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class StreamingUtils {
    private StreamingUtils() {
    }

    public static TypedValue<String> consumeStreamAndClose(InputStream stream, MediaType targetMediaType, Charset targetCharset) {
        return StreamingUtils.consumeStringTransformAndClose(stream, targetCharset, targetMediaType, targetCharset);
    }

    public static TypedValue<String> consumeStringTransformAndClose(Object stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        if (stream == null) {
            return StreamingUtils.toTypedValue("", targetMediaType, targetCharset);
        }
        if (stream instanceof String) {
            return StreamingUtils.toTypedValue((String)stream, targetMediaType, targetCharset);
        }
        if (stream instanceof InputStream) {
            InputStream is = (InputStream)stream;
            return StreamingUtils.doConsumeAndClose(is, sourceCharset, targetMediaType, targetCharset);
        }
        throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
    }

    private static TypedValue<String> doConsumeAndClose(InputStream stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        try {
            TypedValue<String> typedValue = StreamingUtils.toTypedValue(IOUtils.toString((InputStream)stream, (Charset)sourceCharset), targetMediaType, targetCharset);
            return typedValue;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static TypedValue<String> toTypedValue(String value, MediaType mediaType, Charset encoding) {
        return new TypedValue((Object)value, DataType.builder().mediaType(mediaType).charset(encoding).build());
    }
}

