/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.runtime.connection;

import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import jakarta.inject.Inject;
import java.util.Map;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.ic.internal.error.ConnectivityError;
import org.mule.runtime.extension.ic.internal.runtime.connection.Connection;
import org.mule.runtime.extension.ic.internal.runtime.interpreter.ModelInterpreterProvider;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;

public abstract class BaseConnectivityConnectionProvider
implements CachedConnectionProvider<Connection>,
Initialisable,
Startable,
Stoppable {
    @Inject
    protected ModelInterpreterProvider modelInterpreterProvider;
    @Inject
    protected HttpService httpService;
    protected ProxyConfig proxyConfig;
    protected TlsContextFactory tlsContext;
    protected HttpClient httpClient;
    private final MuleConnectionProviderSerializableModel connectionProviderModel;
    private static final String ERROR_MESSAGE = "Error testing connection";
    private static final String ERROR_DETAILS = "No additional info";
    private static final String HTTP_CLIENT_NAME = "universal-connectivity-%s-http-client";

    public BaseConnectivityConnectionProvider(MuleConnectionProviderSerializableModel connectionProviderModel) {
        this.connectionProviderModel = connectionProviderModel;
    }

    public ConnectionValidationResult validate(Connection connection) {
        try {
            ConnectionValidationResult result = connection.testConnection();
            if (result.isValid()) {
                return ConnectionValidationResult.success();
            }
            String errorMessage = this.isEmpty(result.getMessage()) ? ERROR_MESSAGE : result.getMessage();
            String errorDetails = this.isEmpty(result.getException().getMessage()) ? ERROR_DETAILS : result.getException().getMessage();
            return ConnectionValidationResult.failure((String)errorMessage, (Exception)new RuntimeException(errorMessage + ": " + errorDetails));
        }
        catch (RuntimeException e) {
            return ConnectionValidationResult.failure((String)ERROR_MESSAGE, (Exception)new ModuleException(e.getMessage(), (ErrorTypeDefinition)ConnectivityError.CONNECTIVITY, (Throwable)e));
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public final void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
    }

    public void start() {
        this.startHttpClient();
    }

    private void startHttpClient() {
        HttpClientConfiguration.Builder configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContext).setProxyConfig(this.proxyConfig).setName(String.format(HTTP_CLIENT_NAME, this.connectionProviderModel.getAuthenticationTypeName()));
        if (this.httpService == null) {
            throw new RuntimeException("Failed to setup Mule Runtime HttpService");
        }
        this.httpClient = this.httpService.getClientFactory().create(configuration.build());
        this.httpClient.start();
    }

    public void stop() {
        this.httpClient.stop();
    }

    public Connection connect() {
        return new Connection(this.getParameters(), this.connectionProviderModel, this.modelInterpreterProvider.getMuleConnectivityService(), this.httpClient);
    }

    public void disconnect(Connection connection) {
    }

    public abstract Map<String, Object> getParameters();
}

