/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.ic.internal.error;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class ErrorMessageBuilder {
    private ErrorMessageBuilder() {
    }

    public static Message buildErrorMessage(Result<Object, Object> errorResult) {
        Message.Builder builder = Message.builder().payload(ErrorMessageBuilder.getPayloadTypedValue(errorResult)).mediaType(ErrorMessageBuilder.getMediaType(errorResult));
        ErrorMessageBuilder.setAttributes(errorResult, builder);
        return builder.build();
    }

    private static TypedValue<Object> getPayloadTypedValue(Result<Object, Object> response) {
        if (response.getOutput() == null) {
            return TypedValue.of(null);
        }
        DataType dataType = DataType.builder().type(response.getOutput().getClass()).mediaType(ErrorMessageBuilder.getMediaType(response)).build();
        return new TypedValue(response.getOutput(), dataType, response.getByteLength());
    }

    private static void setAttributes(Result<Object, Object> errorResult, Message.Builder builder) {
        errorResult.getAttributes().ifPresent(attributes -> {
            DataType dataType = DataType.builder().type(attributes.getClass()).mediaType(errorResult.getAttributesMediaType().orElse(MediaType.APPLICATION_JAVA)).build();
            builder.attributes(new TypedValue(attributes, dataType));
        });
    }

    private static MediaType getMediaType(Result<Object, Object> response) {
        return response.getMediaType().orElse(MediaType.APPLICATION_JSON);
    }
}

