/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.mule.internal.loader.ExtensionModelTestUtils;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;
import org.mule.tck.classlaoder.TestClassLoader;
import org.skyscreamer.jsonassert.JSONAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="Reuse")
@Story(value="Extension Extension Model")
public class MuleSdkPluginExtensionModelLoaderTestCase
extends AbstractMuleSdkAstTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleSdkPluginExtensionModelLoaderTestCase.class);
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionModelJson.updateExpectedFilesOnError");
    private final ExtensionModelJsonSerializer serializer = new ExtensionModelJsonSerializer(true);

    @Test
    public void whenResourceIsNotFoundThenFailsWithConfigurationException() {
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.getExtensionModelFrom("extensions/non-existent.xml"));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)CoreMatchers.instanceOf(ConfigurationException.class));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)"extensions/non-existent.xml"));
    }

    @Test
    public void whenExtensionWithoutDescriptionThenFailsDuringParsingValidations() {
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.getExtensionModelFrom("extensions/extension-without-description.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)"The content of element 'extension' is not complete."));
    }

    @Test
    public void whenExtensionDoesNotHaveNameThenFailsDuringParsingValidations() {
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.getExtensionModelFrom("extensions/extension-without-name.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)"Attribute 'name' must appear on element 'description'"));
    }

    @Test
    public void whenResourceIsAppInsteadOfExtensionThenFails() {
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.getExtensionModelFrom("app-as-mule-extension.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)"Extension from artifact 'TestExtension' is missing a required top level element. 'extension:description' is expected."));
    }

    @Test
    public void whenResourceIsEmptyAppInsteadOfExtensionThenFails() {
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.getExtensionModelFrom("mule-empty-app-config.xml"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)StringContains.containsString((String)"Extension from artifact 'TestExtension' is missing a required top level element. 'extension:description' is expected."));
    }

    @Test
    public void loadingIsDoneWithTheSpecifiedClassLoader() {
        URL existentResource = IOUtils.getResourceAsUrl((String)"extensions/extension-fully-parameterized.xml", ((Object)((Object)this)).getClass(), (boolean)true, (boolean)true);
        MatcherAssert.assertThat((Object)existentResource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String nonexistentResourceName = "nonExistentResource";
        TestClassLoader testClassLoader = new TestClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        testClassLoader.addResource("nonExistentResource", existentResource);
        ExtensionModelTestUtils.loadMuleSdkExtension("nonExistentResource", (ClassLoader)testClassLoader, astParserExtensionModels);
        MuleRuntimeException thrown = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.getExtensionModelFrom("nonExistentResource"));
        MatcherAssert.assertThat((Object)thrown.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(FileNotFoundException.class));
    }

    @Test
    public void loadExtensionExtensionModel() throws Exception {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-fully-parameterized.xml");
        String actualSerialized = this.serializer.serialize(extensionModel);
        String expectedSerializedPath = "models/extension-fully-parameterized.json";
        String expectedSerialized = IOUtils.getResourceAsString((String)expectedSerializedPath, ((Object)((Object)this)).getClass());
        try {
            JSONAssert.assertEquals((String)expectedSerialized, (String)actualSerialized, (boolean)true);
        }
        catch (AssertionError e) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                this.updateExpectedJson(expectedSerializedPath, actualSerialized);
            }
            LOGGER.error(actualSerialized);
            throw e;
        }
        LicenseModelProperty expectedLicensingProperty = (LicenseModelProperty)extensionModel.getModelProperty(LicenseModelProperty.class).get();
        MatcherAssert.assertThat((Object)expectedLicensingProperty.requiresEeLicense(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)expectedLicensingProperty.isAllowsEvaluationLicense(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)expectedLicensingProperty.getRequiredEntitlement(), (Matcher)CoreMatchers.is(Optional.of("Premium Extension")));
    }

    @Test
    public void whenExtensionHasSelfReferencesThenTheExtensionModelIsCorrect() {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-self-referencing.xml");
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void whenExtensionModelIsLoadedThenArtifactCoordinatesAreCorrect() throws Exception {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-fully-parameterized.xml");
        MatcherAssert.assertThat((Object)((ArtifactCoordinates)extensionModel.getArtifactCoordinates().get()), (Matcher)CoreMatchers.is((Object)ExtensionModelTestUtils.TEST_ARTIFACT_COORDINATES));
    }

    private ExtensionModel getExtensionModelFrom(String extensionFile) {
        return ExtensionModelTestUtils.loadMuleSdkExtension(extensionFile, ((Object)((Object)this)).getClass().getClassLoader(), astParserExtensionModels);
    }

    @Override
    protected String getConfigFile() {
        return null;
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    private void updateExpectedJson(String expectedJsonPath, String json) throws URISyntaxException, IOException {
        File root = new File(IOUtils.getResourceAsUrl((String)expectedJsonPath, ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile().getParentFile();
        File testDir = new File(root, "src/test/resources/");
        File target = new File(testDir, expectedJsonPath);
        Files.writeString(Paths.get(target.getAbsolutePath(), new String[0]), (CharSequence)json, new OpenOption[0]);
        LOGGER.info(target.getAbsolutePath() + " was fixed");
    }
}

