/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.loader.enricher.MetadataTypeEnricher;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParserSdkBuilder;
import org.mule.sdk.api.stereotype.MuleStereotypes;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Parameters")
public class MuleSdkParameterModelParserConfigNamesTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private MuleSdkParameterModelParserSdkBuilder baseParameterParserBuilder;
    private MetadataType someValidMetadataType = (MetadataType)Mockito.mock(MetadataType.class);

    @Before
    public void setUp() {
        this.someValidMetadataType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build();
        HashMap<String, MetadataType> typeLoaderTypes = new HashMap<String, MetadataType>();
        typeLoaderTypes.put("somevalid", this.someValidMetadataType);
        typeLoaderTypes.put("some:some-config-colliding-with-type", this.someValidMetadataType);
        this.baseParameterParserBuilder = new MuleSdkParameterModelParserSdkBuilder("someparam", "somevalid").withTypeLoaderTypes(Collections.unmodifiableMap(typeLoaderTypes)).withExtensionInContext(this.buildExtensionDeclarer());
    }

    private ExtensionDeclarer buildExtensionDeclarer() {
        XmlDslModel xmlDslModel = XmlDslModel.builder().setPrefix("some").build();
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
        extensionDeclarer.named("Some Extension").onVersion("1.0.0").fromVendor("Mulesoft").withCategory(Category.COMMUNITY).withXmlDsl(xmlDslModel).withConstruct("some-construct");
        extensionDeclarer.withConfig("some-config");
        extensionDeclarer.withConfig("some-config-colliding-with-type");
        return extensionDeclarer;
    }

    @Test
    @Description(value="Checks that when the parameter type matches a configuration from an extension, it is treated as a configuration name")
    public void parameterTypeMatchingConfigurationFromOtherExtensionIsTreatedAsReference() {
        StereotypeModel expectedStereotype = StereotypeModelBuilder.newStereotype((String)"some-config", (String)"SOME").withParent(MuleStereotypes.CONFIG).build();
        ObjectType expectedType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(ConfigurationProvider.class.getName()).with((TypeAnnotation)new ClassInformationAnnotation(ConfigurationProvider.class)).build();
        MuleSdkParameterModelParser parameterModelParser = this.baseParameterParserBuilder.withType("some:some-config").build();
        Assert.assertThat((Object)parameterModelParser.getType(), (Matcher)CoreMatchers.is((Object)expectedType));
        Assert.assertThat((Object)parameterModelParser.getAllowedStereotypes((StereotypeModelFactory)Mockito.mock(StereotypeModelFactory.class)), (Matcher)IsIterableContainingInOrder.contains((Object[])new StereotypeModel[]{expectedStereotype}));
    }

    @Test
    @Description(value="Checks that when the parameter type matches the namespace of an extension but not an actual configuration, it is treated as invalid")
    public void parameterTypeMatchingExtensionPrefixButNoConfigRaisesException() {
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Parameter 'someparam' references unknown type 'some:invalid'");
        this.baseParameterParserBuilder.withType("some:invalid").build();
    }

    @Test
    @Description(value="Checks that when the parameter type matches a configuration on an extension but also a type in the type loader, the type loader takes precedence. Whether that situation is possible or not, is of no concern to the parser, hence the test")
    public void parameterTypeMatchingExtensionConfigCollidingWithTypeInTypeLoaderPrioritizesTypeLoader() {
        MuleSdkParameterModelParser parameterModelParser = this.baseParameterParserBuilder.withType("some:some-config-colliding-with-type").build();
        MetadataType expectedType = new MetadataTypeEnricher().enrich(this.someValidMetadataType, Collections.singleton(new TypedValueTypeAnnotation()));
        Assert.assertThat((Object)parameterModelParser.getType(), (Matcher)CoreMatchers.is((Object)expectedType));
    }

    @Test
    @Description(value="Checks that when the parameter type matches a component of an extension which is not a configuration, it is treated as invalid")
    public void parameterTypeMatchingExtensionConstructRaisesException() {
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Parameter 'someparam' references unknown type 'some:some-construct'");
        this.baseParameterParserBuilder.withType("some:some-construct").build();
    }
}

