/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.ast;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.extension.api.provider.RuntimeExtensionModelProviderLoaderUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public abstract class AbstractMuleSdkAstTestCase
extends AbstractMuleTestCase {
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();
    protected static Set<ExtensionModel> astParserExtensionModels;

    protected abstract String getConfigFile();

    @BeforeClass
    public static void beforeClass() throws Exception {
        astParserExtensionModels = new LinkedHashSet<ExtensionModel>(RuntimeExtensionModelProviderLoaderUtils.discoverRuntimeExtensionModels());
    }

    protected static void addDependencyExtension(ExtensionModel extension) {
        astParserExtensionModels.add(extension);
    }

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        AstXmlParser.Builder astParserBuilder = AstXmlParser.builder().withExtensionModels(astParserExtensionModels).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey));
        if (!this.validateSchema()) {
            astParserBuilder.withSchemaValidationsDisabled();
        }
        this.customizeAstParserBuilder(astParserBuilder);
        this.parser = astParserBuilder.build();
    }

    protected void customizeAstParserBuilder(AstXmlParser.Builder astParserBuilder) {
    }

    protected boolean validateSchema() {
        return false;
    }

    protected ArtifactAst getArtifactAst() {
        return this.getArtifactAst(this.getConfigFile());
    }

    protected ArtifactAst getArtifactAst(String configFile) {
        ArtifactAst artifactAst = this.parser.parse(new URL[]{this.classLoader.getResource(configFile)});
        MatcherAssert.assertThat((Object)MuleAstUtils.validatorBuilder().build().validate(artifactAst).getItems(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        return artifactAst;
    }

    protected ValidationResult parseAstExpectingValidationErrors(String configFile) {
        ArtifactAst artifactAst = this.parser.parse(new URL[]{this.classLoader.getResource(configFile)});
        ValidationResult validationResult = MuleAstUtils.validatorBuilder().build().validate(artifactAst);
        MatcherAssert.assertThat((Object)validationResult.getItems(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyCollection.empty())));
        return validationResult;
    }

    protected ComponentAst getTopLevelComponent(ArtifactAst ast, String componentName) {
        return ast.topLevelComponentsStream().filter(componentAst -> ((String)componentAst.getComponentId().get()).equals(componentName)).findFirst().get();
    }

    protected ComponentAst getChild(ComponentAst ast, String childName) {
        return (ComponentAst)ast.directChildrenStreamByIdentifier(null, childName).findFirst().get();
    }

    protected Optional<ComponentAst> getOptionalChild(ComponentAst ast, String childName) {
        return ast.directChildrenStreamByIdentifier(null, childName).findFirst();
    }
}

