/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

final class Utils {
    private Utils() {
    }

    public static TypeLoader mockTypeLoader(Map<String, MetadataType> metadataTypesToAdd) {
        TypeLoader typeLoader = (TypeLoader)Mockito.mock(TypeLoader.class);
        MetadataType voidMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)typeLoader.load("void")).thenReturn(Optional.of(voidMetadataType));
        for (Map.Entry<String, MetadataType> metadataType : metadataTypesToAdd.entrySet()) {
            Mockito.when((Object)typeLoader.load(metadataType.getKey())).thenReturn(Optional.of(metadataType.getValue()));
        }
        return typeLoader;
    }

    public static ComponentAst mockDeprecatedAst(String since, String message, String toRemoveIn) {
        ComponentParameterAst sinceAst = Utils.singleParameterAst(since);
        ComponentParameterAst messageAst = Utils.singleParameterAst(message);
        ComponentParameterAst toRemoveInAst = Utils.singleParameterAst(toRemoveIn);
        ComponentAst deprecatedAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)deprecatedAst.getParameter("General", "since")).thenReturn((Object)sinceAst);
        Mockito.when((Object)deprecatedAst.getParameter("General", "message")).thenReturn((Object)messageAst);
        Mockito.when((Object)deprecatedAst.getParameter("General", "toRemoveIn")).thenReturn((Object)toRemoveInAst);
        return deprecatedAst;
    }

    public static <T> ComponentParameterAst singleParameterAst(T value) {
        ComponentParameterAst parameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)parameterAst.getValue()).thenReturn((Object)Either.right(value));
        return parameterAst;
    }

    public static ComponentAst mockOutputAst(String payloadType, String attributesType) {
        ComponentAst outputAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Utils.mockTypeElement(outputAst, "payload-type", payloadType);
        Utils.mockTypeElement(outputAst, "attributes-type", attributesType);
        return outputAst;
    }

    public static void setMockAstChild(ComponentAst componentAst, String childName, ComponentAst childAst) {
        Mockito.when((Object)componentAst.directChildrenStreamByIdentifier(null, childName)).thenAnswer(invocation -> Stream.of(childAst));
    }

    public static ComponentAst mockErrorAst(String type, String parent) {
        ComponentParameterAst typeParam = Utils.singleParameterAst(type);
        ComponentParameterAst parentParam = Utils.singleParameterAst(parent);
        ComponentAst errorAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)errorAst.getParameter("General", "type")).thenReturn((Object)typeParam);
        Mockito.when((Object)errorAst.getParameter("General", "parent")).thenReturn((Object)parentParam);
        return errorAst;
    }

    private static void mockTypeElement(ComponentAst outputAst, String elementName, String typeName) {
        Mockito.when((Object)outputAst.directChildrenStreamByIdentifier(null, elementName)).thenAnswer(invocation -> {
            if (typeName != null) {
                ComponentParameterAst attributesTypeParameterAst = Utils.singleParameterAst(typeName);
                ComponentAst attributesTypeAst = (ComponentAst)Mockito.mock(ComponentAst.class);
                Mockito.when((Object)attributesTypeAst.getIdentifier()).thenReturn((Object)ComponentIdentifier.builder().namespace("this").name(elementName).build());
                Mockito.when((Object)attributesTypeAst.getParameter("General", "type")).thenReturn((Object)attributesTypeParameterAst);
                return Stream.of(attributesTypeAst);
            }
            return Stream.empty();
        });
    }
}

