/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.extension.api.loader.parser.ErrorModelParser;

public class MuleSdkErrorModelParser
implements ErrorModelParser {
    private static final String MULE = "mule".toUpperCase(Locale.ROOT);
    private final String namespace;
    private final String type;
    private final boolean isMuleError;
    private ErrorModelParser parent;
    private boolean suppressed;

    public MuleSdkErrorModelParser(ErrorModel errorModel) {
        this(errorModel.getNamespace(), errorModel.getType(), errorModel.getParent().map(MuleSdkErrorModelParser::new).orElse(null));
    }

    public MuleSdkErrorModelParser(String namespace, String type, ErrorModelParser parent) {
        this.namespace = namespace;
        this.type = type;
        this.isMuleError = MULE.equals(namespace);
        this.setParent(parent);
    }

    public MuleSdkErrorModelParser(ErrorType errorType) {
        this(errorType.getNamespace(), errorType.getIdentifier(), Optional.ofNullable(errorType.getParentErrorType()).map(MuleSdkErrorModelParser::new).orElse(null));
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isMuleError() {
        return this.isMuleError;
    }

    public Optional<ErrorModelParser> getParent() {
        return Optional.ofNullable(this.parent);
    }

    protected void setParent(ErrorModelParser parent) {
        this.parent = parent;
    }

    public void setSuppressed() {
        this.suppressed = true;
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public int hashCode() {
        return Objects.hash(this.getNamespace(), this.getType(), this.getParent());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MuleSdkErrorModelParser that = (MuleSdkErrorModelParser)o;
        return Objects.equals(this.getNamespace(), that.getNamespace()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getParent(), that.getParent());
    }
}

