/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.enricher.MetadataTypeEnricher;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParserSdkBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Parameters")
public class MuleSdkParameterModelParserTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private MuleSdkParameterModelParserSdkBuilder baseParameterParserBuilder;
    private MetadataType someValidMetadataType;

    @Before
    public void setUp() {
        this.someValidMetadataType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).anyType().build();
        this.baseParameterParserBuilder = new MuleSdkParameterModelParserSdkBuilder("someparam", "somevalid").withTypeLoaderTypes(Collections.singletonMap("somevalid", this.someValidMetadataType));
    }

    @Test
    public void invalidParameterTypeRaisesException() {
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Parameter 'someparam' references unknown type 'invalid'");
        this.baseParameterParserBuilder.withType("invalid").build();
    }

    @Test
    public void parameterTypeCanNotBeVoid() {
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Parameter 'someparam' references type 'void', which is forbidden for parameters");
        this.baseParameterParserBuilder.withType("void").build();
    }

    @Test
    public void parameterTypeCanBeSomeValidParameterInTheApplicationTypeLoader() {
        MuleSdkParameterModelParser parameterModelParser = this.baseParameterParserBuilder.withType("somevalid").build();
        MetadataType expectedType = new MetadataTypeEnricher().enrich(this.someValidMetadataType, Collections.singleton(new TypedValueTypeAnnotation()));
        Assert.assertThat((Object)parameterModelParser.getType(), (Matcher)Matchers.is((Object)expectedType));
    }

    @Test
    public void when_parameterAstHasNotDeprecationParameter_then_parserHasNotDeprecationModel() {
        MuleSdkParameterModelParser parameterModelParser = this.baseParameterParserBuilder.build();
        Assert.assertThat((Object)parameterModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void when_parameterAstHasDeprecationParameter_then_parserHasDeprecationModelWithCorrespondingValues() {
        MuleSdkParameterModelParser parameterModelParser = this.baseParameterParserBuilder.withDeprecationModel("1.1.0", "Some Message", "2.0.0").build();
        Assert.assertThat((Object)parameterModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)parameterModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.1.0"));
        Assert.assertThat((Object)deprecationModel.getMessage(), (Matcher)Matchers.is((Object)"Some Message"));
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.of("2.0.0")));
    }

    @Test
    public void when_toRemoveInParameterIsNotConfigured_then_theDeprecationModelReturnsAnEmptyOptional() {
        MuleSdkParameterModelParser parameterModelParser = this.baseParameterParserBuilder.withDeprecationModel("1.1.0", "Some Message", null).build();
        Assert.assertThat((Object)parameterModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)parameterModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.empty()));
    }
}

