/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkOperationModelParserSdk;

public class MuleSdkOperationModelParserSdkTestCase {
    private MuleSdkOperationModelParserSdk operationModelParser;
    private ComponentAst operationAst;

    @Before
    public void setup() {
        ComponentParameterAst operationName = this.stringParameterAst("mockName");
        this.operationAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.operationAst.getParameter("General", "name")).thenReturn((Object)operationName);
        TypeLoader typeLoader = (TypeLoader)Mockito.mock(TypeLoader.class);
        this.operationModelParser = new MuleSdkOperationModelParserSdk(this.operationAst, typeLoader);
    }

    @Test
    public void when_operationAstHasNotDeprecationParameter_then_parserHasNotDeprecationModel() {
        Assert.assertThat((Object)this.operationModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void when_operationAstHasDeprecationParameter_then_parserHasDeprecationModelWithCorrespondingValues() {
        ComponentAst deprecatedAst = this.mockDeprecatedAst("1.1.0", "Some Message", "2.0.0");
        Mockito.when((Object)this.operationAst.directChildrenStreamByIdentifier(null, "deprecated")).thenAnswer(invocation -> Stream.of(deprecatedAst));
        Assert.assertThat((Object)this.operationModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)this.operationModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.1.0"));
        Assert.assertThat((Object)deprecationModel.getMessage(), (Matcher)Matchers.is((Object)"Some Message"));
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.of("2.0.0")));
    }

    @Test
    public void when_toRemoveInParameterIsNotConfigured_then_theDeprecationModelReturnsAnEmptyOptional() {
        ComponentAst deprecatedAst = this.mockDeprecatedAst("1.1.0", "Some Message", null);
        Mockito.when((Object)this.operationAst.directChildrenStreamByIdentifier(null, "deprecated")).thenAnswer(invocation -> Stream.of(deprecatedAst));
        Assert.assertThat((Object)this.operationModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)this.operationModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.empty()));
    }

    private ComponentAst mockDeprecatedAst(String since, String message, String toRemoveIn) {
        ComponentParameterAst sinceAst = this.stringParameterAst(since);
        ComponentParameterAst messageAst = this.stringParameterAst(message);
        ComponentParameterAst toRemoveInAst = this.stringParameterAst(toRemoveIn);
        ComponentAst deprecatedAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)deprecatedAst.getParameter("General", "since")).thenReturn((Object)sinceAst);
        Mockito.when((Object)deprecatedAst.getParameter("General", "message")).thenReturn((Object)messageAst);
        Mockito.when((Object)deprecatedAst.getParameter("General", "toRemoveIn")).thenReturn((Object)toRemoveInAst);
        return deprecatedAst;
    }

    private ComponentParameterAst stringParameterAst(String value) {
        ComponentParameterAst parameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)parameterAst.getValue()).thenReturn((Object)Either.right((Object)value));
        return parameterAst;
    }
}

