/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleOperationExecutionTestCase
extends MuleArtifactFunctionalTestCase {
    protected String getConfigFile() {
        return "mule-salutation-operations-config.xml";
    }

    @Test
    @Description(value="Calls a flow that executes the simple <this:hello-world> operation")
    public void executeHelloWorldOperation() throws Exception {
        this.assertHelloWorldResponse(this.flowRunner("salutationFlow").run());
    }

    @Test
    @Description(value="Calls a flow that executes the <this:hello-and-introduce> operation which is a composed one")
    public void executeComposedOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("composedOperation").run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"good morning  Malaga!  Hello lad, my name is Anthony Stark"));
        Assert.assertThat((Object)resultEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="Calls a flow that executes the <this:hello-place> operation which takes exclusive optional parameters")
    public void executeExclusiveOptionalsOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("exclusiveOptionalsFlow").run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"good morning  London "));
        Assert.assertThat((Object)resultEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="Calls a flow that executes the <this:non-blocking-hello-world> operation which is non blocking")
    public void executeNonBlockingOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("nonBlockingOperationFlow").run();
        this.assertHelloWorldResponse(resultEvent);
    }

    @Test
    @Description(value="Calls a flow that executes the <this:blocking-hello-world> operation which is blocking")
    public void executeBlockingOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("blockingOperationFlow").run();
        this.assertHelloWorldResponse(resultEvent);
    }

    @Test
    @Description(value="Calls a flow that executes the <this:repeated-hello-world> operation which is implemented recursively")
    public void executeRecursiveOperation() throws Exception {
        CoreEvent resultEvent = this.flowRunner("recursiveOperationFlow").run();
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"Hello,   Malaga! Hello,   Malaga! Hello,   Malaga! "));
        Assert.assertThat((Object)resultEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Description(value="Verifies that operations params don't exit its own scope when composed")
    public void captureParamsAcrossOperations() throws Exception {
        CoreEvent resultEvent = this.flowRunner("interceptAndDumpParameters").run();
        Assert.assertThat((Object)resultEvent.getParameters().size(), (Matcher)CoreMatchers.is((Object)0));
        Map dump = (Map)resultEvent.getMessage().getPayload().getValue();
        Assert.assertThat((Object)dump.size(), (Matcher)CoreMatchers.is((Object)2));
        List interception = (List)dump.get("helloWorld");
        Assert.assertThat((Object)interception, (Matcher)Matchers.hasSize((int)1));
        Map params = (Map)interception.get(0);
        this.assertValue((TypedValue)params.get("receiver"), "Malaga!");
        this.assertValue((TypedValue)params.get("prefix"), "");
        this.assertValue((TypedValue)params.get("greeting"), "good morning");
        this.assertValue((TypedValue)params.get("suffix"), null);
        Assert.assertThat(params.keySet(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"nationalID", "name"})));
        interception = (List)dump.get("introduceMyself");
        Assert.assertThat((Object)interception, (Matcher)Matchers.hasSize((int)1));
        params = (Map)interception.get(0);
        this.assertValue((TypedValue)params.get("nationalID"), "5");
        this.assertValue((TypedValue)params.get("name"), "Anthony Stark");
        Assert.assertThat(params.keySet(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"receiver", "prefix", "greeting", "suffix"})));
    }

    @Test
    @Description(value="Flow vars don't make it into operations and operation vars don't exit them")
    public void variablesProperlyScoped() throws Exception {
        Object token = new Object();
        CoreEvent result = ((FlowRunner)this.flowRunner("composedOperation").withVariable("token", token)).run();
        Assert.assertThat((Object)result.getVariables().size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertValue((TypedValue)result.getVariables().get("token"), token);
    }

    @Test
    @Description(value="Message payload and attributes do not propagate into operations")
    public void messageProperlyScoped() throws Exception {
        CoreEvent result = ((FlowRunner)((FlowRunner)this.flowRunner("salutationFlow").withPayload((Object)"Hello!")).withAttributes(new Object())).run();
        this.assertHelloWorldResponse(result);
    }

    private void assertValue(TypedValue<?> typedValue, Object rawValue) {
        Assert.assertThat((Object)typedValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)rawValue));
    }

    private void assertHelloWorldResponse(CoreEvent resultEvent) {
        Assert.assertThat((Object)resultEvent.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)"Hello,   Malaga! "));
        Assert.assertThat((Object)resultEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

