/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;

public class MuleSdkParameterModelParserSdk
extends BaseMuleSdkExtensionModelParser
implements ParameterModelParser {
    protected final ComponentAst parameter;
    private final TypeLoader typeLoader;
    private String name;

    public MuleSdkParameterModelParserSdk(ComponentAst parameter, TypeLoader typeLoader) {
        this.parameter = parameter;
        this.typeLoader = typeLoader;
        this.parseStructure();
    }

    private void parseStructure() {
        this.name = (String)this.getParameter(this.parameter, "name");
    }

    public List<StereotypeModel> getAllowedStereotypes(StereotypeModelFactory factory) {
        return Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getOptionalParameter(this.parameter, "description").orElse("");
    }

    public MetadataType getType() {
        String type = (String)this.getParameter(this.parameter, "type");
        return (MetadataType)this.typeLoader.load(type).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Parameter '%s' references unknown type '%s'", this.getName(), type)));
    }

    public boolean isRequired() {
        return true;
    }

    public Object getDefaultValue() {
        return null;
    }

    public ParameterRole getRole() {
        return ParameterRole.BEHAVIOUR;
    }

    public ExpressionSupport getExpressionSupport() {
        return ExpressionSupport.valueOf((String)((String)this.getParameter(this.parameter, "expressionSupport")));
    }

    public Optional<LayoutModel> getLayoutModel() {
        return Optional.empty();
    }

    public Optional<ParameterDslConfiguration> getDslConfiguration() {
        return Optional.empty();
    }

    public boolean isExcludedFromConnectivitySchema() {
        return false;
    }

    public boolean isConfigOverride() {
        return (Boolean)this.getParameter(this.parameter, "configOverride");
    }

    public boolean isComponentId() {
        return false;
    }

    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.emptyList();
    }

    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    public Optional<DisplayModel> getDisplayModel() {
        String summary = (String)this.getParameter(this.parameter, "summary");
        if (!StringUtils.isBlank((String)summary)) {
            return Optional.of(DisplayModel.builder().summary(summary).build());
        }
        return Optional.empty();
    }

    public Optional<OAuthParameterModelProperty> getOAuthParameterModelProperty() {
        return Optional.empty();
    }

    public Set<String> getSemanticTerms() {
        return Collections.emptySet();
    }
}

