/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParserSdk;
import org.mule.runtime.module.extension.mule.internal.loader.parser.Utils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Parameters")
public class MuleSdkParameterModelParserSdkTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private MuleSdkParameterModelParserSdk parameterModelParser;
    private ComponentAst componentAst;
    private MetadataType someValidMetadataType;

    @Before
    public void setUp() {
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst parameterNameAst = Utils.stringParameterAst("someparam");
        Mockito.when((Object)this.componentAst.getParameter("General", "name")).thenReturn((Object)parameterNameAst);
        this.someValidMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        TypeLoader typeLoader = Utils.mockTypeLoader(Collections.singletonMap("somevalid", this.someValidMetadataType));
        this.parameterModelParser = new MuleSdkParameterModelParserSdk(this.componentAst, typeLoader);
    }

    @Test
    public void invalidParameterTypeRaisesException() {
        ComponentParameterAst typeParameterAst = Utils.stringParameterAst("invalid");
        Mockito.when((Object)this.componentAst.getParameter("General", "type")).thenReturn((Object)typeParameterAst);
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Parameter 'someparam' references unknown type 'invalid'");
        this.parameterModelParser.getType();
    }

    @Test
    public void parameterTypeCanNotBeVoid() {
        ComponentParameterAst typeParameterAst = Utils.stringParameterAst("void");
        Mockito.when((Object)this.componentAst.getParameter("General", "type")).thenReturn((Object)typeParameterAst);
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Parameter 'someparam' references type 'void', which is forbidden for parameters");
        this.parameterModelParser.getType();
    }

    @Test
    public void parameterTypeCanBeSomeValidParameterInTheApplicationTypeLoader() {
        ComponentParameterAst typeParameterAst = Utils.stringParameterAst("somevalid");
        Mockito.when((Object)this.componentAst.getParameter("General", "type")).thenReturn((Object)typeParameterAst);
        Assert.assertThat((Object)this.parameterModelParser.getType(), (Matcher)Matchers.is((Object)this.someValidMetadataType));
    }

    @Test
    public void when_parameterAstHasNotDeprecationParameter_then_parserHasNotDeprecationModel() {
        Assert.assertThat((Object)this.parameterModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void when_parameterAstHasDeprecationParameter_then_parserHasDeprecationModelWithCorrespondingValues() {
        ComponentAst deprecatedAst = Utils.mockDeprecatedAst("1.1.0", "Some Message", "2.0.0");
        Utils.setMockAstChild(this.componentAst, "deprecated", deprecatedAst);
        Assert.assertThat((Object)this.parameterModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)this.parameterModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.1.0"));
        Assert.assertThat((Object)deprecationModel.getMessage(), (Matcher)Matchers.is((Object)"Some Message"));
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.of("2.0.0")));
    }

    @Test
    public void when_toRemoveInParameterIsNotConfigured_then_theDeprecationModelReturnsAnEmptyOptional() {
        ComponentAst deprecatedAst = Utils.mockDeprecatedAst("1.1.0", "Some Message", null);
        Utils.setMockAstChild(this.componentAst, "deprecated", deprecatedAst);
        Assert.assertThat((Object)this.parameterModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)this.parameterModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.empty()));
    }
}

