/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.utils;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.model.notification.ImmutableNotificationModel;
import org.mule.runtime.module.extension.mule.internal.loader.parser.utils.Characteristic;

@Feature(value="Reuse")
@Story(value="Operations")
public class CharacteristicsTestsCase {
    @Test
    @Description(value="Checks that AnyMatchCharacteristic is updated accordingly after different computations")
    public void anyMatchTestCase() {
        OperationModel model = (OperationModel)Mockito.mock(OperationModel.class);
        Reference value = new Reference((Object)Boolean.FALSE);
        Characteristic.AnyMatchCharacteristic characteristic = new Characteristic.AnyMatchCharacteristic(x -> (Boolean)value.get());
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)false));
        characteristic.computeFrom(model);
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)characteristic.getValue(), (Matcher)CoreMatchers.is((Object)false));
        value.set((Object)true);
        characteristic.computeFrom(model);
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.getValue(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Checks that AnyMatchFilteringCharacteristic is updated accordingly after different computations, including filters")
    public void anyMathFilterTestCase() {
        OperationModel model = (OperationModel)Mockito.mock(OperationModel.class);
        ComponentAst ast = (ComponentAst)Mockito.mock(ComponentAst.class);
        Reference value = new Reference((Object)Boolean.FALSE);
        Reference filter = new Reference((Object)Boolean.FALSE);
        Reference ignore = new Reference((Object)Boolean.FALSE);
        Characteristic.AnyMatchFilteringCharacteristic characteristic = new Characteristic.AnyMatchFilteringCharacteristic(x -> (Boolean)value.get(), x -> (Boolean)filter.get(), x -> (Boolean)ignore.get());
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)false));
        characteristic.computeFrom(model);
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)characteristic.getValue(), (Matcher)CoreMatchers.is((Object)false));
        value.set((Object)true);
        characteristic.computeFrom(model);
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.getValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.filterComponent(ast), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)characteristic.ignoreComponent(ast), (Matcher)CoreMatchers.is((Object)false));
        filter.set((Object)true);
        MatcherAssert.assertThat((Object)characteristic.filterComponent(ast), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.ignoreComponent(ast), (Matcher)CoreMatchers.is((Object)false));
        ignore.set((Object)true);
        MatcherAssert.assertThat((Object)characteristic.filterComponent(ast), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.ignoreComponent(ast), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Checks that AggregatedNotificationsCharacteristic is updated accordingly and aggregates results after different computations")
    public void aggregatedTestCase() {
        OperationModel model1 = (OperationModel)Mockito.mock(OperationModel.class);
        OperationModel model2 = (OperationModel)Mockito.mock(OperationModel.class);
        OperationModel model3 = (OperationModel)Mockito.mock(OperationModel.class);
        ImmutableNotificationModel notification1 = new ImmutableNotificationModel("test", "1", (MetadataType)Mockito.mock(MetadataType.class));
        ImmutableNotificationModel notification2 = new ImmutableNotificationModel("test", "2", (MetadataType)Mockito.mock(MetadataType.class));
        ImmutableNotificationModel notification3 = new ImmutableNotificationModel("test", "3", (MetadataType)Mockito.mock(MetadataType.class));
        ImmutableNotificationModel notification4 = new ImmutableNotificationModel("test", "4", (MetadataType)Mockito.mock(MetadataType.class));
        ImmutableNotificationModel notification5 = new ImmutableNotificationModel("test", "5", (MetadataType)Mockito.mock(MetadataType.class));
        Mockito.when((Object)model1.getNotificationModels()).thenReturn(new HashSet<NotificationModel>(Arrays.asList(notification1, notification2)));
        Mockito.when((Object)model2.getNotificationModels()).thenReturn(new HashSet<NotificationModel>(Arrays.asList(notification3, notification4)));
        Mockito.when((Object)model3.getNotificationModels()).thenReturn(new HashSet<ImmutableNotificationModel>(Collections.singletonList(notification5)));
        Characteristic.AggregatedNotificationsCharacteristic characteristic = new Characteristic.AggregatedNotificationsCharacteristic();
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)false));
        characteristic.computeFrom(model1);
        characteristic.computeFrom(model2);
        characteristic.computeFrom(model3);
        MatcherAssert.assertThat((Object)characteristic.hasDefinitiveValue(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)characteristic.hasValue(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)characteristic.getValue(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)characteristic.getValue(), (Matcher)CoreMatchers.hasItems((Object[])new NotificationModel[]{notification1, notification2, notification3, notification4, notification5}));
    }
}

