/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.validation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.mule.internal.validation.AbstractConfigFileValidationTestCase;

@Feature(value="Reuse")
@Stories(value={@Story(value="Operations"), @Story(value="Parameters"), @Story(value="Types Catalog")})
public class TypesValidationsTestCase
extends AbstractConfigFileValidationTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    @Description(value="Operation must have an output element")
    public void operationMustHaveAnOutputElement() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Operation 'operationWithoutOutput' is missing its <output> declaration");
        this.parseConfig("validation/no-output-operation.xml");
    }

    @Test
    @Description(value="Operation output must have a payload-type element")
    public void operationOutputMustHaveAPayloadTypeElement() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Operation 'outputWithoutPayloadType' is missing its <payload-type> declaration");
        this.parseConfig("validation/output-without-payload-type-operation.xml");
    }

    @Test
    @Description(value="Operation output must have a payload-type present in the ApplicationTypeLoader")
    public void operationOutputMustHaveAPayloadTypePresentInTheApplicationTypeLoader() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Component <operation:payload-type> defines type as 'invalid' but such type is not defined in the application");
        this.parseConfig("validation/output-with-invalid-payload-type-operation.xml");
    }

    @Test
    @Description(value="Operation output payload-type can be a primitive")
    public void payloadTypeStringIsOk() throws Exception {
        this.parseConfig("validation/output-with-string-payload-type-operation.xml");
    }

    @Test
    @Description(value="Operation output payload-type can be void")
    public void payloadTypeVoidIsOk() throws Exception {
        this.parseConfig("validation/output-with-void-payload-type-operation.xml");
    }

    @Test
    @Description(value="Parameter type can't be void")
    public void parameterTypeCanNotBeVoid() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Parameter 'someparam' references type 'void', which is forbidden for parameters");
        this.parseConfig("validation/parameter-with-void-type.xml");
    }

    @Test
    @Description(value="Parameter type can be a primitive")
    public void parameterTypeCanBeString() throws Exception {
        this.parseConfig("validation/parameter-with-string-type.xml");
    }
}

