/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.api.extension;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;

@Feature(value="Reuse")
@Story(value="Extension Extension Model")
public class MuleExtensionExtensionModelTestCase
extends AbstractMuleSdkAstTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Override
    protected String getConfigFile() {
        return "extensions/extension-fully-parameterized.xml";
    }

    @Override
    protected boolean validateSchema() {
        return true;
    }

    @Test
    public void configFileCanBeParsedAndHasExpectedExtensionModel() {
        ArtifactAst extensionAst = this.getArtifactAst();
        ComponentAst extensionComponentAst = this.getRootComponent(extensionAst);
        ExtensionModel extensionExtensionModel = extensionComponentAst.getExtensionModel();
        MatcherAssert.assertThat((Object)extensionExtensionModel.getName(), (Matcher)CoreMatchers.is((Object)"Mule Extension DSL"));
    }

    @Test
    public void operationsCanBeRetrievedAsChildrenOfTopLevel() {
        ArtifactAst extensionAst = this.getArtifactAst();
        ComponentAst extensionComponentAst = this.getRootComponent(extensionAst);
        MatcherAssert.assertThat((Object)extensionComponentAst.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAst operationComponentAst = (ComponentAst)extensionComponentAst.directChildren().get(0);
        MatcherAssert.assertThat((Object)operationComponentAst.getIdentifier(), (Matcher)CoreMatchers.is((Object)ComponentIdentifier.buildFromStringRepresentation((String)"operation:def")));
        MatcherAssert.assertThat((Object)operationComponentAst.getComponentType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.OPERATION_DEF));
        MatcherAssert.assertThat((Object)operationComponentAst.getExtensionModel().getName(), (Matcher)CoreMatchers.is((Object)"Mule Operations DSL"));
    }

    @Test
    public void parametersAreParsedAndHaveTheRightValueWhenFullyDefined() {
        ArtifactAst extensionAst = this.getArtifactAst();
        ComponentAst extensionComponentAst = this.getRootComponent(extensionAst);
        LinkedHashMap<String, Matcher<Object>> expectedParameters = new LinkedHashMap<String, Matcher<Object>>();
        expectedParameters.put("name", CoreMatchers.is((Object)"Fully Parameterized Extension"));
        expectedParameters.put("category", CoreMatchers.is((Object)"PREMIUM"));
        expectedParameters.put("vendor", CoreMatchers.is((Object)"Extension Producers Inc."));
        expectedParameters.put("requiredEntitlement", CoreMatchers.is((Object)"Premium Extension"));
        expectedParameters.put("requiresEnterpriseLicense", CoreMatchers.is((Object)true));
        expectedParameters.put("allowsEvaluationLicense", CoreMatchers.is((Object)false));
        expectedParameters.put("namespace", CoreMatchers.is((Object)"http://www.mulesoft.org/schema/a/different/path/mule/fully-parameterized"));
        expectedParameters.put("prefix", CoreMatchers.is((Object)"fully-param"));
        this.assertThatParametersAreExactly(extensionComponentAst, expectedParameters);
    }

    @Test
    public void parametersAreParsedAndHaveTheRightValueWhenMinimallyDefined() {
        ArtifactAst extensionAst = this.getArtifactAst("extensions/extension-minimally-parameterized.xml");
        ComponentAst extensionComponentAst = this.getRootComponent(extensionAst);
        LinkedHashMap<String, Matcher<Object>> expectedParameters = new LinkedHashMap<String, Matcher<Object>>();
        expectedParameters.put("name", CoreMatchers.is((Object)"Minimally Parameterized Extension"));
        expectedParameters.put("category", CoreMatchers.is((Object)Category.COMMUNITY.name()));
        expectedParameters.put("vendor", CoreMatchers.is((Object)"Mulesoft"));
        expectedParameters.put("requiredEntitlement", CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        expectedParameters.put("requiresEnterpriseLicense", CoreMatchers.is((Object)false));
        expectedParameters.put("allowsEvaluationLicense", CoreMatchers.is((Object)true));
        expectedParameters.put("namespace", CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        expectedParameters.put("prefix", CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.assertThatParametersAreExactly(extensionComponentAst, expectedParameters);
    }

    @Test
    public void extensionWithoutNameFailsWhenParsing() {
        this.expected.expect(MuleRuntimeException.class);
        this.expected.expectMessage(CoreMatchers.containsString((String)"Attribute 'name' must appear on element 'extension'"));
        this.getArtifactAst("extensions/extension-without-name.xml");
    }

    private ComponentAst getRootComponent(ArtifactAst ast) {
        MatcherAssert.assertThat((Object)ast.topLevelComponents(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAst onlyTopLevelComponent = (ComponentAst)ast.topLevelComponentsStream().findFirst().get();
        ComponentIdentifier extensionIdentifier = onlyTopLevelComponent.getIdentifier();
        MatcherAssert.assertThat((Object)extensionIdentifier.getName(), (Matcher)CoreMatchers.is((Object)"extension"));
        MatcherAssert.assertThat((Object)extensionIdentifier.getNamespace(), (Matcher)CoreMatchers.is((Object)"extension"));
        MatcherAssert.assertThat((Object)extensionIdentifier.getNamespaceUri(), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/mule-extension"));
        return onlyTopLevelComponent;
    }

    private void assertThatParametersAreExactly(ComponentAst componentAst, Map<String, Matcher<Object>> expectedParameters) {
        MatcherAssert.assertThat((Object)componentAst.getParameters(), (Matcher)IsCollectionWithSize.hasSize((int)expectedParameters.size()));
        for (Map.Entry<String, Matcher<Object>> entry : expectedParameters.entrySet()) {
            MatcherAssert.assertThat(this.getParameterValue(componentAst, entry.getKey()), entry.getValue());
        }
    }

    private <T> T getParameterValue(ComponentAst componentAst, String paramName) {
        return (T)componentAst.getParameter("General", paramName).getValue().getRight();
    }
}

