/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.extension.ExtensionManager;

@Feature(value="Reuse")
@Stories(value={@Story(value="Application Extension Model"), @Story(value="Error Handling")})
public class ErrorHandlingExtensionModelTestCase
extends MuleArtifactFunctionalTestCase {
    private static final Map<String, List<String>> expectedErrors = new HashMap<String, List<String>>();
    @Inject
    private ExtensionManager extensionManager;

    @BeforeClass
    public static void setupExpectedErrors() {
        expectedErrors.put("raiseThis", Collections.singletonList("THIS:CUSTOM"));
        expectedErrors.put("raiseCustom", Collections.singletonList("THIS:CUSTOM"));
        expectedErrors.put("heisenbergCureCancer", Arrays.asList("HEISENBERG:HEALTH", "HEISENBERG:OAUTH2"));
        expectedErrors.put("withMappingInsideBody", Arrays.asList("HEISENBERG:HEALTH", "HEISENBERG:OAUTH2"));
        expectedErrors.put("divisionByZero", Collections.emptyList());
        expectedErrors.put("operationSilencingOneSpecificErrorAndRaisingAnother", Arrays.asList("HEISENBERG:OAUTH2", "THIS:CUSTOM"));
        expectedErrors.put("operationSilencingAllErrorsAndRaisingAnother", Collections.singletonList("THIS:CUSTOM"));
        expectedErrors.put("operationSilencingAllHeisenbergErrorsAndRaisingAnother", Collections.singletonList("THIS:HEALTH"));
        expectedErrors.put("operationSilencingAllHealthErrorsWithinACatchAll", Collections.singletonList("HEISENBERG:OAUTH2"));
        expectedErrors.put("operationRaisingUniqueErrorAndCatchingIt", Collections.emptyList());
        expectedErrors.put("operationWithMultipleOnErrorContinues", Collections.emptyList());
        expectedErrors.put("operationCatchingAllButWithWhen", Arrays.asList("HEISENBERG:OAUTH2", "HEISENBERG:OAUTH2"));
    }

    protected String[] getConfigFiles() {
        return new String[]{"mule-error-handling-operations-config.xml", "mule-error-handling-with-try-operations-config.xml"};
    }

    @Test
    public void appExtensionModelContainsRaisedErrors() {
        ExtensionModel extensionModel = this.getAppExtensionModel();
        List<String> raisedErrors = ErrorHandlingExtensionModelTestCase.getRaisedErrors(extensionModel);
        Assert.assertThat(raisedErrors, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"THIS:CONNECTIVITY", "MULE:ANY", "MULE:RETRY_EXHAUSTED", "THIS:RETRY_EXHAUSTED", "MULE:CONNECTIVITY", "HEISENBERG:HEALTH", "HEISENBERG:OAUTH2", "THIS:CUSTOM", "THIS:HEALTH", "THIS:UNIQUE"}));
    }

    @Test
    public void eachOperationDeclaresTheErrorsThatRaises() {
        for (Map.Entry<String, List<String>> expectedForOperation : expectedErrors.entrySet()) {
            String operationName = expectedForOperation.getKey();
            List<String> expected = expectedForOperation.getValue();
            this.assertRaisedErrors(operationName, expected);
        }
    }

    private void assertRaisedErrors(String operationName, Collection<String> expectedListOfErrors) {
        OperationModel operationModel = this.getOperationModel(operationName);
        List<String> actualRaisedErrors = ErrorHandlingExtensionModelTestCase.getRaisedErrors(operationModel);
        Assert.assertThat((String)String.format("Actual list for '%s': %s", operationName, actualRaisedErrors), actualRaisedErrors, (Matcher)Matchers.hasSize((int)expectedListOfErrors.size()));
        for (String item : expectedListOfErrors) {
            Assert.assertThat((String)String.format("Actual list for '%s': %s", operationName, actualRaisedErrors), actualRaisedErrors, (Matcher)Matchers.hasItem((Object)item));
        }
    }

    private OperationModel getOperationModel(String operationName) {
        return (OperationModel)this.getAppExtensionModel().getOperationModel(operationName).orElseThrow(() -> new IllegalArgumentException(String.format("Operation '%s' not found in application's extension model", operationName)));
    }

    private static List<String> getRaisedErrors(ExtensionModel extensionModel) {
        return extensionModel.getErrorModels().stream().map(Object::toString).collect(Collectors.toList());
    }

    private static List<String> getRaisedErrors(OperationModel operationModel) {
        return operationModel.getErrorModels().stream().map(Object::toString).collect(Collectors.toList());
    }

    private ExtensionModel getAppExtensionModel() {
        return (ExtensionModel)this.extensionManager.getExtension(muleContext.getConfiguration().getId()).get();
    }
}

