/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.ast;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.extension.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

public abstract class AbstractMuleSdkAstTestCase
extends AbstractMuleTestCase {
    private ClassLoader classLoader;
    private AstXmlParser parser;
    private final Map<String, String> properties = new HashMap<String, String>();
    private static List<ExtensionModel> runtimeExtensionModels;

    protected abstract String getConfigFile();

    @BeforeClass
    public static void beforeClass() throws Exception {
        runtimeExtensionModels = new ArrayList<ExtensionModel>();
        Collection runtimeExtensionModelProviders = new SpiServiceRegistry().lookupProviders(RuntimeExtensionModelProvider.class, Thread.currentThread().getContextClassLoader());
        for (RuntimeExtensionModelProvider runtimeExtensionModelProvider : runtimeExtensionModelProviders) {
            runtimeExtensionModels.add(runtimeExtensionModelProvider.createExtensionModel());
        }
    }

    @Before
    public void before() {
        this.properties.clear();
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        AstXmlParser.Builder astParserBuilder = AstXmlParser.builder().withExtensionModels(runtimeExtensionModels).withPropertyResolver(propertyKey -> this.properties.getOrDefault(propertyKey, propertyKey));
        if (!this.validateSchema()) {
            astParserBuilder.withSchemaValidationsDisabled();
        }
        this.customizeAstParserBuilder(astParserBuilder);
        this.parser = astParserBuilder.build();
    }

    protected void customizeAstParserBuilder(AstXmlParser.Builder astParserBuilder) {
    }

    protected boolean validateSchema() {
        return false;
    }

    protected ArtifactAst getArtifactAst() {
        return this.parser.parse(new URL[]{this.classLoader.getResource(this.getConfigFile())});
    }

    protected ArtifactAst getArtifactAst(String configFile) {
        return this.parser.parse(new URL[]{this.classLoader.getResource(configFile)});
    }

    protected ComponentAst getTopLevelComponent(ArtifactAst ast, String componentName) {
        return ast.topLevelComponentsStream().filter(componentAst -> ((String)componentAst.getComponentId().get()).equals(componentName)).findFirst().get();
    }

    protected ComponentAst getChild(ComponentAst ast, String childName) {
        return (ComponentAst)ast.directChildrenStreamByIdentifier(null, childName).findFirst().get();
    }
}

