/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;

@Feature(value="Reuse")
@Stories(value={@Story(value="Operations"), @Story(value="Error Handling")})
public class MuleOperationErrorHandlingTestCase
extends MuleArtifactFunctionalTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"mule-error-handling-operations-config.xml", "mule-error-handling-with-try-operations-config.xml"};
    }

    @Test
    public void errorWithinAppWithNamespaceThis() throws Exception {
        this.flowRunner("raiseErrorWithinThisNamespace").runExpectingException(ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
    }

    @Test
    public void divisionByZero() throws Exception {
        this.flowRunner("divisionByZeroFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MULE", (String)"EXPRESSION"));
    }

    @Test
    public void heisenbergCureCancer() throws Exception {
        this.flowRunner("heisenbergCureCancerFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"HEISENBERG", (String)"HEALTH"));
    }

    @Test
    public void usingOperationRaiseError() throws Exception {
        this.flowRunner("usingOperationRaiseErrorFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
    }

    @Test
    public void errorMappingInInvocation() throws Exception {
        this.flowRunner("errorMappingOnInvocationFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED"));
    }

    @Test
    public void errorMappingInsideBody() throws Exception {
        this.flowRunner("errorMappingInsideBodyFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED"));
    }

    @Test
    public void errorMappingInsideBodyAndInInvocation() throws Exception {
        this.flowRunner("errorMappingInsideBodyAndInInvocationFlow").runExpectingException(ErrorTypeMatcher.errorType((String)"MY", (String)"MAPPED_TWICE"));
    }

    @Test
    public void callingOperationThatSilencesErrors() throws Exception {
        this.flowRunner("flowCallingOperationThatSilencesOneSpecificErrorAndRaisesAnother").runExpectingException(ErrorTypeMatcher.errorType((String)"THIS", (String)"CUSTOM"));
    }
}

