/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleOperationParameterContentTypeTestCase
extends MuleArtifactFunctionalTestCase {
    protected String getConfigFile() {
        return "mule-schema-extracting-config.xml";
    }

    @Test
    @Issue(value="W-11389978")
    public void whenParameterMediaTypeIsSpecifiedThenItIsPreserved() throws Exception {
        CoreEvent resultEvent = ((FlowRunner)((FlowRunner)this.flowRunner("showSchemaFlow").withMediaType(MediaType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8))).withPayload((Object)"{\"hello!\": 5}")).run();
        Map payload = (Map)resultEvent.getMessage().getPayload().getValue();
        Assert.assertThat(payload.get("encoding"), (Matcher)CoreMatchers.is((Object)"UTF-8"));
        Assert.assertThat(payload.get("mediaType"), (Matcher)CoreMatchers.is((Object)"application/json; charset=UTF-8"));
        Assert.assertThat(payload.get("mimeType"), (Matcher)CoreMatchers.is((Object)"application/json"));
        Assert.assertThat(payload.get("raw"), (Matcher)CoreMatchers.is((Object)"{\"hello!\": 5}"));
        Assert.assertThat(payload.get("contentLength"), (Matcher)CoreMatchers.is((Object)13));
        Assert.assertThat((Object)resultEvent.getMessage().getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

