/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;

abstract class BaseMuleSdkExtensionModelParser {
    protected static final String DEPRECATED_CONSTRUCT_NAME = "deprecated";
    private static final String MESSAGE_PARAMETER = "message";
    private static final String SINCE_PARAMETER = "since";
    private static final String TO_REMOVE_IN_PARAMETER = "toRemoveIn";

    BaseMuleSdkExtensionModelParser() {
    }

    protected <T> T getParameter(ComponentAst ast, String paramName) {
        return (T)ast.getParameter("General", paramName).getValue().getRight();
    }

    protected <T> Optional<T> getOptionalParameter(ComponentAst ast, String paramName) {
        return Optional.ofNullable(ast.getParameter("General", paramName)).map(paramAst -> paramAst.getValue().getRight());
    }

    protected Stream<ComponentAst> getChildren(ComponentAst component, String childName) {
        return component.directChildrenStreamByIdentifier(null, childName);
    }

    protected Optional<ComponentAst> getSingleChild(ComponentAst component, String childName) {
        return this.getChildren(component, childName).findFirst();
    }

    protected DeprecationModel buildDeprecationModel(ComponentAst deprecationAst) {
        String message = (String)this.getParameter(deprecationAst, MESSAGE_PARAMETER);
        String since = (String)this.getParameter(deprecationAst, SINCE_PARAMETER);
        String toRemoveIn = this.getOptionalParameter(deprecationAst, TO_REMOVE_IN_PARAMETER).orElse(null);
        return new ImmutableDeprecationModel(message, since, toRemoveIn);
    }
}

