/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.validation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.mule.internal.validation.AbstractConfigFileValidationTestCase;

@Feature(value="Reuse")
@Stories(value={@Story(value="Operations"), @Story(value="Error Handling")})
public class RaiseErrorValidationTestCase
extends AbstractConfigFileValidationTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    @Description(value="Operation can't use mule:raise-error")
    public void operationCanNotUseCoreRaiseError() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Usages of the component 'raise-error' are not allowed inside a Mule Operation Definition (operation:def)");
        this.parseConfig("validation/operation-with-core-raise-error.xml");
    }

    @Test
    @Description(value="Operation's raise-error is not allowed to specify a namespace")
    public void operationRaiseErrorIsNotAllowedToSpecifyNamespace() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Operation raise error component (operation:raise-error) is not allowed to specify a namespace: 'APP'");
        this.parseConfig("validation/operation-raise-error-specifying-namespace.xml");
    }

    @Test
    @Description(value="Operation's raise-error is not allowed to specify THIS namespace")
    public void operationRaiseErrorIsNotAllowedToSpecifyNamespaceThis() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("Operation raise error component (operation:raise-error) is not allowed to specify a namespace: 'THIS'");
        this.parseConfig("validation/operation-raise-error-specifying-namespace-this.xml");
    }

    @Test
    @Description(value="Operation's raise-error allowed configs don't fail")
    public void operationRaiseErrorAllowedConfigs() throws Exception {
        this.parseConfig("validation/operation-raise-error-allowed-usages.xml");
    }
}

