/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.mule.internal.loader.ExtensionModelTestUtils;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;
import org.mule.tck.classlaoder.TestClassLoader;
import org.skyscreamer.jsonassert.JSONAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="Reuse")
@Story(value="Extension Extension Model")
public class MuleSdkPluginExtensionModelLoaderTestCase
extends AbstractMuleSdkAstTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleSdkPluginExtensionModelLoaderTestCase.class);
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionModelJson.updateExpectedFilesOnError");
    private final ExtensionModelJsonSerializer serializer = new ExtensionModelJsonSerializer();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void whenResourceIsNotFoundThenFailsWithConfigurationException() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConfigurationException.class));
        this.expectedException.expectMessage("extensions/non-existent.xml");
        this.getExtensionModelFrom("extensions/non-existent.xml");
    }

    @Test
    public void whenExtensionWithoutDescriptionThenFailsDuringParsingValidations() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("The content of element 'extension' is not complete.");
        this.getExtensionModelFrom("extensions/extension-without-description.xml");
    }

    @Test
    public void whenExtensionDoesNotHaveNameThenFailsDuringParsingValidations() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Attribute 'name' must appear on element 'description'");
        this.getExtensionModelFrom("extensions/extension-without-name.xml");
    }

    @Test
    public void whenResourceIsAppInsteadOfExtensionThenFails() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage("Extension from artifact 'artifact' is missing a required top level element. 'extension:description' is expected.");
        this.getExtensionModelFrom("app-as-mule-extension.xml");
    }

    @Test
    public void whenResourceIsEmptyAppInsteadOfExtensionThenFails() {
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage("Extension from artifact 'artifact' is missing a required top level element. 'extension:description' is expected.");
        this.getExtensionModelFrom("mule-empty-app-config.xml");
    }

    @Test
    public void loadingIsDoneWithTheSpecifiedClassLoader() {
        URL existentResource = IOUtils.getResourceAsUrl((String)"extensions/extension-fully-parameterized.xml", ((Object)((Object)this)).getClass(), (boolean)true, (boolean)true);
        MatcherAssert.assertThat((Object)existentResource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String nonexistentResourceName = "nonExistentResource";
        TestClassLoader testClassLoader = new TestClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        testClassLoader.addResource("nonExistentResource", existentResource);
        ExtensionModelTestUtils.loadMuleSdkExtension("nonExistentResource", (ClassLoader)testClassLoader, astParserExtensionModels);
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(FileNotFoundException.class)));
        this.getExtensionModelFrom("nonExistentResource");
    }

    @Test
    public void loadExtensionExtensionModel() throws Exception {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-fully-parameterized.xml");
        String actualSerialized = this.serializer.serialize(extensionModel);
        String expectedSerializedPath = "models/extension-fully-parameterized.json";
        String expectedSerialized = IOUtils.getResourceAsString((String)expectedSerializedPath, ((Object)((Object)this)).getClass());
        try {
            JSONAssert.assertEquals((String)expectedSerialized, (String)actualSerialized, (boolean)true);
        }
        catch (AssertionError e) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                this.updateExpectedJson(expectedSerializedPath, actualSerialized);
            }
            LOGGER.error(actualSerialized);
            throw e;
        }
        LicenseModelProperty expectedLicensingProperty = (LicenseModelProperty)extensionModel.getModelProperty(LicenseModelProperty.class).get();
        MatcherAssert.assertThat((Object)expectedLicensingProperty.requiresEeLicense(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)expectedLicensingProperty.isAllowsEvaluationLicense(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)expectedLicensingProperty.getRequiredEntitlement(), (Matcher)CoreMatchers.is(Optional.of("Premium Extension")));
    }

    @Test
    public void whenExtensionHasSelfReferencesThenTheExtensionModelIsCorrect() {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-self-referencing.xml");
        MatcherAssert.assertThat((Object)extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void whenExtensionModelIsLoadedThenArtifactCoordinatesAreCorrect() throws Exception {
        ExtensionModel extensionModel = this.getExtensionModelFrom("extensions/extension-fully-parameterized.xml");
        MatcherAssert.assertThat(extensionModel.getArtifactCoordinates().get(), (Matcher)CoreMatchers.is((Object)ExtensionModelTestUtils.TEST_ARTIFACT_COORDINATES));
    }

    private ExtensionModel getExtensionModelFrom(String extensionFile) {
        return ExtensionModelTestUtils.loadMuleSdkExtension(extensionFile, ((Object)((Object)this)).getClass().getClassLoader(), astParserExtensionModels);
    }

    @Override
    protected String getConfigFile() {
        return null;
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    private void updateExpectedJson(String expectedJsonPath, String json) throws URISyntaxException, IOException {
        File root = new File(IOUtils.getResourceAsUrl((String)expectedJsonPath, ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile().getParentFile();
        File testDir = new File(root, "src/test/resources/");
        File target = new File(testDir, expectedJsonPath);
        FileUtils.stringToFile((String)target.getAbsolutePath(), (String)json);
        LOGGER.info(target.getAbsolutePath() + " was fixed");
    }
}

