/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.module.extension.mule.internal.loader.parser.ParameterLayoutParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.Utils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Parameters")
public class ParameterLayoutParserTestCase
extends AbstractMuleTestCase {
    private static final Map<String, String> EXPECTED_SEMANTIC_TERM = new HashMap<String, String>(11);

    @Test
    public void whenTheParameterAstHasNotMetadataThenParsedLayoutModelAndDisplayModelAreNotPresent() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.emptyParameterAst();
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void whenTheParameterMetadataIsEmptyThenParsedLayoutModelAndDisplayModelAreNotPresent() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void setDisplayNameOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withDisplayName("The display name").build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((DisplayModel)parser.getDisplayModel().get()).getDisplayName(), (Matcher)Matchers.is((Object)"The display name"));
    }

    @Test
    public void setExampleOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withExample("The Example").build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((DisplayModel)parser.getDisplayModel().get()).getExample(), (Matcher)Matchers.is((Object)"The Example"));
    }

    @Test
    public void setSummaryOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withSummary("The Summary").build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((DisplayModel)parser.getDisplayModel().get()).getSummary(), (Matcher)Matchers.is((Object)"The Summary"));
    }

    @Test
    public void setPathWithoutParams() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withPathAst(new MockPathAstBuilder().build()).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((DisplayModel)parser.getDisplayModel().get()).getPathModel().isPresent(), (Matcher)Matchers.is((Object)true));
        PathModel pathModel = (PathModel)((DisplayModel)parser.getDisplayModel().get()).getPathModel().get();
        Assert.assertThat((Object)pathModel.getType(), (Matcher)Matchers.is((Object)PathModel.Type.ANY));
        Assert.assertThat((Object)pathModel.acceptsUrls(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)pathModel.getLocation(), (Matcher)Matchers.is((Object)PathModel.Location.ANY));
        Assert.assertThat((Object)pathModel.getFileExtensions(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void setPathWithParams() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withPathAst(new MockPathAstBuilder().withType("FILE").acceptsUrls(true).withLocation("EMBEDDED").withAcceptedFileExtensions("xml,json").build()).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((DisplayModel)parser.getDisplayModel().get()).getPathModel().isPresent(), (Matcher)Matchers.is((Object)true));
        PathModel pathModel = (PathModel)((DisplayModel)parser.getDisplayModel().get()).getPathModel().get();
        Assert.assertThat((Object)pathModel.getType(), (Matcher)Matchers.is((Object)PathModel.Type.FILE));
        Assert.assertThat((Object)pathModel.acceptsUrls(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)pathModel.getLocation(), (Matcher)Matchers.is((Object)PathModel.Location.EMBEDDED));
        Assert.assertThat((Object)pathModel.getFileExtensions(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"xml", "json"}));
    }

    @Test
    public void directoryPathTypeIgnoresFileExtensions() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withPathAst(new MockPathAstBuilder().withType("DIRECTORY").withAcceptedFileExtensions("xml,json").build()).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((DisplayModel)parser.getDisplayModel().get()).getPathModel().isPresent(), (Matcher)Matchers.is((Object)true));
        PathModel pathModel = (PathModel)((DisplayModel)parser.getDisplayModel().get()).getPathModel().get();
        Assert.assertThat((Object)pathModel.getType(), (Matcher)Matchers.is((Object)PathModel.Type.DIRECTORY));
        Assert.assertThat((Object)pathModel.acceptsUrls(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)pathModel.getLocation(), (Matcher)Matchers.is((Object)PathModel.Location.ANY));
        Assert.assertThat((Object)pathModel.getFileExtensions(), (Matcher)Matchers.empty());
    }

    @Test
    public void setTextTrueOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withText(true).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((LayoutModel)parser.getLayoutModel().get()).isText(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void setTextFalseOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withText(false).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((LayoutModel)parser.getLayoutModel().get()).isText(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void setSecretOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withSecret("CLIENT_SECRET").build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((LayoutModel)parser.getLayoutModel().get()).isPassword(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)parser.getSemanticTerms(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"connectivity.clientSecret"}));
    }

    @Test
    public void setOrderOnly() {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withOrder(3).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((LayoutModel)parser.getLayoutModel().get()).getOrder().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(((LayoutModel)parser.getLayoutModel().get()).getOrder().get(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void expectedSemanticTerms() {
        for (Map.Entry<String, String> entry : EXPECTED_SEMANTIC_TERM.entrySet()) {
            this.assertExpectedSemanticTerm(entry.getKey(), entry.getValue());
        }
    }

    private void assertExpectedSemanticTerm(String configuredValue, String expectedTerm) {
        ComponentAst parameterAst = ParameterLayoutParserTestCase.mockParameterWithLayoutAst(new MockLayoutAstBuilder().withSecret(configuredValue).build());
        ParameterLayoutParser parser = new ParameterLayoutParser(parameterAst);
        Assert.assertThat((Object)parser.getDisplayModel().isPresent(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)parser.getLayoutModel().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((LayoutModel)parser.getLayoutModel().get()).isPassword(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)String.format("Semantic term for %s didn't match", configuredValue), (Object)parser.getSemanticTerms(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{expectedTerm}));
    }

    private static ComponentAst emptyParameterAst() {
        return (ComponentAst)Mockito.mock(ComponentAst.class);
    }

    private static ComponentAst mockParameterWithLayoutAst(ComponentAst layoutAst) {
        ComponentAst parameterAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)parameterAst.directChildrenStreamByIdentifier(null, "parameter-metadata")).thenReturn(Stream.of(layoutAst));
        return parameterAst;
    }

    static {
        EXPECTED_SEMANTIC_TERM.put("CLIENT_ID", "connectivity.clientId");
        EXPECTED_SEMANTIC_TERM.put("CLIENT_SECRET", "connectivity.clientSecret");
        EXPECTED_SEMANTIC_TERM.put("TOKEN_ID", "connectivity.tokenId");
        EXPECTED_SEMANTIC_TERM.put("PASSWORD", "connectivity.password");
        EXPECTED_SEMANTIC_TERM.put("TOKEN_URL_TEMPLATE", "core.tokenUrlTemplate");
        EXPECTED_SEMANTIC_TERM.put("TOKEN_SECRET", "connectivity.secretToken");
        EXPECTED_SEMANTIC_TERM.put("API_KEY", "connectivity.apiKey");
        EXPECTED_SEMANTIC_TERM.put("SECRET_TOKEN", "connectivity.secretToken");
        EXPECTED_SEMANTIC_TERM.put("SECURITY_TOKEN", "connectivity.securityToken");
        EXPECTED_SEMANTIC_TERM.put("RSA_PRIVATE_KEY", "connectivity.secret");
        EXPECTED_SEMANTIC_TERM.put("SECRET", "connectivity.secret");
    }

    private static class MockPathAstBuilder {
        private final ComponentAst pathAst = (ComponentAst)Mockito.mock(ComponentAst.class);

        MockPathAstBuilder() {
        }

        MockPathAstBuilder withType(String pathType) {
            ComponentParameterAst typeAst = Utils.singleParameterAst(pathType);
            Mockito.when((Object)this.pathAst.getParameter("General", "type")).thenReturn((Object)typeAst);
            return this;
        }

        MockPathAstBuilder acceptsUrls(Boolean acceptsUrls) {
            ComponentParameterAst acceptsUrlsAst = Utils.singleParameterAst(acceptsUrls);
            Mockito.when((Object)this.pathAst.getParameter("General", "acceptsUrls")).thenReturn((Object)acceptsUrlsAst);
            return this;
        }

        MockPathAstBuilder withLocation(String location) {
            ComponentParameterAst locationAst = Utils.singleParameterAst(location);
            Mockito.when((Object)this.pathAst.getParameter("General", "location")).thenReturn((Object)locationAst);
            return this;
        }

        MockPathAstBuilder withAcceptedFileExtensions(String acceptedFileExtensions) {
            ComponentParameterAst acceptedFileExtensionsAst = Utils.singleParameterAst(acceptedFileExtensions);
            Mockito.when((Object)this.pathAst.getParameter("General", "acceptedFileExtensions")).thenReturn((Object)acceptedFileExtensionsAst);
            return this;
        }

        ComponentAst build() {
            return this.pathAst;
        }
    }

    private static class MockLayoutAstBuilder {
        private final ComponentAst layoutAst = (ComponentAst)Mockito.mock(ComponentAst.class);

        MockLayoutAstBuilder() {
        }

        MockLayoutAstBuilder withDisplayName(String displayName) {
            ComponentParameterAst displayNameAst = Utils.singleParameterAst(displayName);
            Mockito.when((Object)this.layoutAst.getParameter("General", "displayName")).thenReturn((Object)displayNameAst);
            return this;
        }

        MockLayoutAstBuilder withExample(String example) {
            ComponentParameterAst exampleAst = Utils.singleParameterAst(example);
            Mockito.when((Object)this.layoutAst.getParameter("General", "example")).thenReturn((Object)exampleAst);
            return this;
        }

        MockLayoutAstBuilder withSummary(String summary) {
            ComponentParameterAst summaryAst = Utils.singleParameterAst(summary);
            Mockito.when((Object)this.layoutAst.getParameter("General", "summary")).thenReturn((Object)summaryAst);
            return this;
        }

        MockLayoutAstBuilder withPathAst(ComponentAst pathAst) {
            Mockito.when((Object)this.layoutAst.directChildrenStreamByIdentifier(null, "path")).thenReturn(Stream.of(pathAst));
            return this;
        }

        MockLayoutAstBuilder withText(boolean isText) {
            ComponentParameterAst isTextAst = Utils.singleParameterAst(isText);
            Mockito.when((Object)this.layoutAst.getParameter("General", "text")).thenReturn((Object)isTextAst);
            return this;
        }

        MockLayoutAstBuilder withSecret(String secret) {
            ComponentParameterAst secretAst = Utils.singleParameterAst(secret);
            Mockito.when((Object)this.layoutAst.getParameter("General", "secret")).thenReturn((Object)secretAst);
            return this;
        }

        MockLayoutAstBuilder withOrder(Integer order) {
            ComponentParameterAst orderAst = Utils.singleParameterAst(order);
            Mockito.when((Object)this.layoutAst.getParameter("General", "order")).thenReturn((Object)orderAst);
            return this;
        }

        ComponentAst build() {
            return this.layoutAst;
        }
    }
}

