/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkOperationModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.Utils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleSdkOperationModelParserTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private MuleSdkOperationModelParser operationModelParser;
    private ComponentAst operationAst;
    private MetadataType someMetadataType;

    @Before
    public void setup() {
        ComponentParameterAst operationName = Utils.singleParameterAst("mockName");
        this.operationAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.operationAst.getParameter("General", "name")).thenReturn((Object)operationName);
        TypeLoader typeLoader = (TypeLoader)Mockito.mock(TypeLoader.class);
        this.someMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)typeLoader.load("some")).thenReturn(Optional.of(this.someMetadataType));
        this.operationModelParser = new MuleSdkOperationModelParser(this.operationAst, "THIS", typeLoader, new ExtensionModelHelper(Collections.emptySet()));
    }

    @Test
    public void when_operationAstHasNotDeprecationParameter_then_parserHasNotDeprecationModel() {
        Assert.assertThat((Object)this.operationModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void when_operationAstHasDeprecationParameter_then_parserHasDeprecationModelWithCorrespondingValues() {
        ComponentAst deprecatedAst = Utils.mockDeprecatedAst("1.1.0", "Some Message", "2.0.0");
        Utils.setMockAstChild(this.operationAst, "deprecated", deprecatedAst);
        Assert.assertThat((Object)this.operationModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)this.operationModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getDeprecatedSince(), (Matcher)Matchers.is((Object)"1.1.0"));
        Assert.assertThat((Object)deprecationModel.getMessage(), (Matcher)Matchers.is((Object)"Some Message"));
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.of("2.0.0")));
    }

    @Test
    public void when_toRemoveInParameterIsNotConfigured_then_theDeprecationModelReturnsAnEmptyOptional() {
        ComponentAst deprecatedAst = Utils.mockDeprecatedAst("1.1.0", "Some Message", null);
        Utils.setMockAstChild(this.operationAst, "deprecated", deprecatedAst);
        Assert.assertThat((Object)this.operationModelParser.getDeprecationModel().isPresent(), (Matcher)Matchers.is((Object)true));
        DeprecationModel deprecationModel = (DeprecationModel)this.operationModelParser.getDeprecationModel().get();
        Assert.assertThat((Object)deprecationModel.getToRemoveIn(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void when_weHaveAnOperation_then_theExecutionTypeIsCpuLite() {
        Assert.assertThat((Object)this.operationModelParser.getExecutionType(), (Matcher)Matchers.is(Optional.of(ExecutionType.CPU_LITE)));
    }

    @Test
    public void when_anOperationHasNotOutput_then_anExceptionIsRaised() {
        this.expected.expect(IllegalOperationModelDefinitionException.class);
        this.expected.expectMessage("Operation 'mockName' is missing its <output> declaration");
        this.operationModelParser.getOutputType();
    }

    @Test
    public void when_anOperationOutputHasNotPayloadType_then_anExceptionIsRaised() {
        ComponentAst output = Utils.mockOutputAst(null, null);
        Utils.setMockAstChild(this.operationAst, "output", output);
        this.expected.expect(IllegalOperationModelDefinitionException.class);
        this.expected.expectMessage("Operation 'mockName' is missing its <payload-type> declaration");
        this.operationModelParser.getOutputType();
    }

    @Test
    public void when_anOperationOutputHasAPayloadTypeNotInTheTypeLoader_then_anExceptionIsRaised() {
        ComponentAst output = Utils.mockOutputAst("notDefined", null);
        Utils.setMockAstChild(this.operationAst, "output", output);
        this.expected.expect(IllegalModelDefinitionException.class);
        this.expected.expectMessage("Component <this:payload-type> defines type as 'notDefined' but such type is not defined in the application");
        this.operationModelParser.getOutputType();
    }

    @Test
    public void when_anOperationOutputHasAPayloadTypeInTheTypeLoader_then_theOutputTypeIsRetrievedFromThere() {
        ComponentAst output = Utils.mockOutputAst("some", null);
        Utils.setMockAstChild(this.operationAst, "output", output);
        Assert.assertThat((Object)this.operationModelParser.getOutputType().getType(), (Matcher)Matchers.is((Object)this.someMetadataType));
    }
}

