/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.api.extension;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.module.extension.mule.internal.loader.ast.AbstractMuleSdkAstTestCase;

@Feature(value="Reuse")
@Story(value="Extension Extension Model")
public class MuleExtensionExtensionModelTestCase
extends AbstractMuleSdkAstTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Override
    protected String getConfigFile() {
        return "extensions/extension-fully-parameterized.xml";
    }

    @Override
    protected boolean validateSchema() {
        return true;
    }

    @Test
    public void configFileCanBeParsedAndHasExpectedExtensionModel() {
        ArtifactAst extensionAst = this.getArtifactAst();
        ComponentAst extensionComponentAst = this.getDescriptionComponent(extensionAst);
        ExtensionModel extensionExtensionModel = extensionComponentAst.getExtensionModel();
        MatcherAssert.assertThat((Object)extensionExtensionModel.getName(), (Matcher)CoreMatchers.is((Object)"Mule Extension DSL"));
    }

    @Test
    public void operationsCanBeRetrievedAsTopLevel() {
        ArtifactAst extensionAst = this.getArtifactAst();
        List operationsComponentAst = extensionAst.topLevelComponentsStream().filter(c -> c.getComponentType() == TypedComponentIdentifier.ComponentType.OPERATION_DEF).collect(Collectors.toList());
        MatcherAssert.assertThat(operationsComponentAst, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAst operationComponentAst = (ComponentAst)operationsComponentAst.get(0);
        MatcherAssert.assertThat((Object)operationComponentAst.getIdentifier(), (Matcher)CoreMatchers.is((Object)ComponentIdentifier.buildFromStringRepresentation((String)"operation:def")));
        MatcherAssert.assertThat((Object)operationComponentAst.getComponentType(), (Matcher)CoreMatchers.is((Object)TypedComponentIdentifier.ComponentType.OPERATION_DEF));
        MatcherAssert.assertThat((Object)operationComponentAst.getExtensionModel().getName(), (Matcher)CoreMatchers.is((Object)"Mule Operations DSL"));
    }

    @Test
    public void parametersAreParsedAndHaveTheRightValueWhenFullyDefined() {
        ArtifactAst extensionAst = this.getArtifactAst();
        ComponentAst descriptionComponentAst = this.getDescriptionComponent(extensionAst);
        ComponentAst licensingComponentAst = this.getChild(descriptionComponentAst, "licensing");
        ComponentAst xmlDslAttributesComponentAst = this.getChild(descriptionComponentAst, "xml-dsl-attributes");
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(descriptionComponentAst, "name")), (Matcher)CoreMatchers.is((Object)"Fully Parameterized Extension"));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(descriptionComponentAst, "category")), (Matcher)CoreMatchers.is((Object)"PREMIUM"));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(descriptionComponentAst, "vendor")), (Matcher)CoreMatchers.is((Object)"Extension Producers Inc."));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(licensingComponentAst, "requiredEntitlement")), (Matcher)CoreMatchers.is((Object)"Premium Extension"));
        MatcherAssert.assertThat((Object)((Boolean)this.getParameterValue(licensingComponentAst, "requiresEnterpriseLicense")), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Boolean)this.getParameterValue(licensingComponentAst, "allowsEvaluationLicense")), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(xmlDslAttributesComponentAst, "namespace")), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/a/different/path/mule/fully-parameterized"));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(xmlDslAttributesComponentAst, "prefix")), (Matcher)CoreMatchers.is((Object)"fully-param"));
    }

    @Test
    public void parametersAreParsedAndHaveTheRightValueWhenMinimallyDefined() {
        ArtifactAst extensionAst = this.getArtifactAst("extensions/extension-minimally-parameterized.xml");
        ComponentAst descriptionComponentAst = this.getDescriptionComponent(extensionAst);
        Optional<ComponentAst> licensingComponentAst = this.getOptionalChild(descriptionComponentAst, "licensing");
        Optional<ComponentAst> xmlDslAttributesComponentAst = this.getOptionalChild(descriptionComponentAst, "xml-dsl-attributes");
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(descriptionComponentAst, "name")), (Matcher)CoreMatchers.is((Object)"Minimally Parameterized Extension"));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(descriptionComponentAst, "category")), (Matcher)CoreMatchers.is((Object)Category.COMMUNITY.name()));
        MatcherAssert.assertThat((Object)((String)this.getParameterValue(descriptionComponentAst, "vendor")), (Matcher)CoreMatchers.is((Object)"Mulesoft"));
        MatcherAssert.assertThat((Object)licensingComponentAst.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)xmlDslAttributesComponentAst.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void extensionWithoutDescriptionFailsWhenParsing() {
        this.expected.expect(MuleRuntimeException.class);
        this.expected.expectMessage(CoreMatchers.containsString((String)"The content of element 'extension' is not complete"));
        this.getArtifactAst("extensions/extension-without-description.xml");
    }

    @Test
    public void extensionWithoutNameFailsWhenParsing() {
        this.expected.expect(MuleRuntimeException.class);
        this.expected.expectMessage(CoreMatchers.containsString((String)"Attribute 'name' must appear on element 'description'"));
        this.getArtifactAst("extensions/extension-without-name.xml");
    }

    @Test
    public void notAnExtensionFailsWhenValidating() {
    }

    @Override
    protected void customizeAstParserBuilder(AstXmlParser.Builder astParserBuilder) {
        astParserBuilder.withArtifactType(ArtifactType.MULE_EXTENSION);
    }

    private ComponentAst getDescriptionComponent(ArtifactAst ast) {
        ComponentIdentifier descriptionIdentifier = ComponentIdentifier.builder().namespaceUri("http://www.mulesoft.org/schema/mule/mule-extension").namespace("extension").name("description").build();
        return ast.topLevelComponentsStream().filter(c -> c.getIdentifier().equals(descriptionIdentifier)).findFirst().get();
    }

    private <T> T getParameterValue(ComponentAst componentAst, String paramName) {
        return (T)componentAst.getParameter("General", paramName).getValue().getRight();
    }
}

