/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleOperationSupportsStreamingTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private ExtensionManager extensionManager;
    private static List<OperationModel> operationModels;

    protected String getConfigFile() {
        return "mule-streaming-ops-config.xml";
    }

    @Test
    @Description(value="Checks that an operation without streaming does not support streaming, and has no parameter for streaming strategy")
    public void withoutStreaming() {
        this.assertForOperation("nonStreaming");
    }

    @Test
    @Description(value="Checks that an operation that returns a repeatable stream does not support streaming, but has no parameter for streaming strategy")
    public void withRepeatableStreaming() {
        this.assertForOperation("withRepeatableStreaming");
    }

    @Test
    @Description(value="Checks that an operation that returns a non repeatable stream does not support streaming, but has no parameter for streaming strategy")
    public void withNonRepeatableStreaming() {
        this.assertForOperation("withNonRepeatableStreaming");
    }

    @Test
    @Description(value="Checks that an operation that returns a repeatable stream does not support streaming even if it's used, but has no parameter for streaming strategy")
    public void withRepeatableStreamingUsed() {
        this.assertForOperation("withRepeatableStreamingUsed");
    }

    @Test
    @Description(value="Checks that an operation that returns a non repeatable stream does not support streaming even if it's consumed, but has no parameter for streaming strategy")
    public void withNonRepeatableStreamingConsumed() {
        this.assertForOperation("withNonRepeatableStreamingConsumed");
    }

    @Test
    @Description(value="Check that an operation that uses an operation with repeatable streaming, but has no parameter for streaming strategy")
    public void usingStreamingOp() {
        this.assertForOperation("usingStreamingOp");
    }

    @Test
    @Description(value="Checks that return type is correct for operations that return a repeatable stream")
    public void repeatableStreamingOperationExecution() throws Exception {
        CoreEvent resultEvent = this.flowRunner("flowRepeatable").run();
        Object stream = resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)stream, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CursorIteratorProvider.class)));
    }

    @Test
    @Description(value="Checks that return type is correct for operations that return a non repeatable stream")
    public void nonRepeatableStreamingOperationExecution() throws Exception {
        CoreEvent resultEvent = this.flowRunner("flowNonRepeatable").keepStreamsOpen().run();
        Object stream = resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)stream, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConsumerStreamingIterator.class)));
        ConsumerStreamingIterator streamingIterator = (ConsumerStreamingIterator)stream;
        MatcherAssert.assertThat((Object)streamingIterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Checks that return type is correct for operations that return a repeatable stream, including when used")
    public void repeatableStreamingUsedOperationExecution() throws Exception {
        CoreEvent resultEvent = this.flowRunner("flowRepeatableUsed").run();
        Object stream = resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)stream, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CursorIteratorProvider.class)));
    }

    @Test
    @Description(value="Checks that return type is correct for operations that return a non repeatable stream, including when consumed")
    public void consumedNonRepeatableStreamingOperationExecution() throws Exception {
        CoreEvent resultEvent = this.flowRunner("flowNonRepeatableConsumed").keepStreamsOpen().run();
        Object stream = resultEvent.getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)stream, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConsumerStreamingIterator.class)));
        ConsumerStreamingIterator streamingIterator = (ConsumerStreamingIterator)stream;
        MatcherAssert.assertThat((Object)streamingIterator.hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertForOperation(String operation) {
        OperationModel model = this.getOperationModel(operation);
        MatcherAssert.assertThat((Object)model.supportsStreaming(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)model.getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals("streamingStrategy")), (Matcher)CoreMatchers.is((Object)false));
    }

    private OperationModel getOperationModel(String name) {
        if (operationModels == null) {
            operationModels = ((ExtensionModel)this.extensionManager.getExtension(muleContext.getConfiguration().getId()).get()).getOperationModels();
        }
        return operationModels.stream().filter(opModel -> opModel.getName().equals(name)).findFirst().get();
    }
}

