/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.mule.testing.processing.strategies.test.api.BarrierProvider;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.processor.strategy.AsyncProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Reuse")
@Story(value="Operations")
public class NoisyNeighboursTestCase
extends MuleArtifactFunctionalTestCase {
    private static final PollingProber prober = new PollingProber(5000L, 100L);
    @Inject
    private BarrierProvider barrierProvider;

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = super.createMuleConfiguration();
        ProcessingStrategyFactory factory = MessageProcessors.createDefaultProcessingStrategyFactory();
        NoisyNeighboursTestCase.setMaxConcurrency(factory, 1);
        configuration.setDefaultProcessingStrategyFactory(factory);
        return configuration;
    }

    protected String getConfigFile() {
        return "noisy-neighbours-test-config.xml";
    }

    @Test
    public void callersAreNotNoisyNeighbours() throws Exception {
        try (Async caller1 = new Async(new FlowRunnerRunnable("caller1"));
             Async caller2 = new Async(new FlowRunnerRunnable("caller2"));){
            BarrierProvider.Barrier barrier = this.barrierProvider.get("sharedBarrier");
            prober.check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)barrier.blockedThreads(), (Matcher)CoreMatchers.is((Object)2));
                return true;
            }));
            barrier.release();
        }
    }

    private static void setMaxConcurrency(ProcessingStrategyFactory processingStrategyFactory, int maxConcurrency) {
        ((AsyncProcessingStrategyFactory)processingStrategyFactory).setMaxConcurrency(maxConcurrency);
    }

    private class FlowRunnerRunnable
    implements Runnable {
        private final FlowRunner flowRunner;

        private FlowRunnerRunnable(String flowName) {
            this.flowRunner = NoisyNeighboursTestCase.this.flowRunner(flowName);
        }

        @Override
        public void run() {
            try {
                this.flowRunner.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Async
    implements AutoCloseable {
        private final Thread thread;

        Async(Runnable runnable) {
            this.thread = new Thread(runnable);
            this.thread.start();
        }

        @Override
        public void close() throws Exception {
            this.thread.join(5000L);
        }
    }
}

