/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.IdentifierParsingUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.mule.internal.dsl.MuleSdkDslConstants;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkErrorsDeclarationParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.Utils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Reuse")
@Stories(value={@Story(value="Extension Extension Model"), @Story(value="Error Handling")})
public class MuleSdkErrorsDeclarationParserTestCase
extends AbstractMuleTestCase {
    private static final String TEST = "TEST";
    private static final ComponentIdentifier TEST_COMPONENT_IDENTIFIER = ComponentIdentifier.builder().name("testName").namespace("testNs").namespaceUri("testUri").build();
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void extensionWithoutErrorsTag() {
        ArtifactAst extensionAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)extensionAst.topLevelComponentsStream()).thenReturn(Stream.empty());
        Map errorParsersMap = new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.is(Collections.emptyMap()));
    }

    @Test
    public void extensionWithEmptyErrorsTag() {
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(new ComponentAst[0]);
        Map errorParsersMap = new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.is(Collections.emptyMap()));
    }

    @Test
    public void errorWithoutNamespace() {
        ComponentAst errorAst = Utils.mockErrorAst("WITHOUT_NS", null);
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(errorAst);
        Map errorParsersMap = new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
        ComponentIdentifier expectedErrorIdentifier = IdentifierParsingUtils.parseErrorType((String)"WITHOUT_NS", (String)TEST);
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.hasKey((Object)expectedErrorIdentifier));
        ErrorModelParser errorModelParser = (ErrorModelParser)errorParsersMap.get(expectedErrorIdentifier);
        Assert.assertThat((Object)errorModelParser.getNamespace(), (Matcher)Matchers.is((Object)TEST));
    }

    @Test
    public void errorWithNamespaceOfSameExtension() {
        ComponentAst errorAst = Utils.mockErrorAst("TEST:WITH_NS", null);
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(errorAst);
        Map errorParsersMap = new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
        ComponentIdentifier expectedErrorIdentifier = IdentifierParsingUtils.parseErrorType((String)"TEST:WITH_NS", (String)TEST);
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.hasKey((Object)expectedErrorIdentifier));
        ErrorModelParser errorModelParser = (ErrorModelParser)errorParsersMap.get(expectedErrorIdentifier);
        Assert.assertThat((Object)errorModelParser.getNamespace(), (Matcher)Matchers.is((Object)TEST));
    }

    @Test
    public void errorWithNamespaceOtherThanTheExtensionOneIsForbidden() {
        ComponentAst errorAst = Utils.mockErrorAst("OTHER_THAN_TEST:WITH_NS", null);
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(errorAst);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("The extension with namespace 'TEST' can't declare the error 'OTHER_THAN_TEST:WITH_NS' with namespace 'OTHER_THAN_TEST'");
        new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
    }

    @Test
    public void parentWithNamespaceOtherThanTheExtensionOneOrMuleIsForbidden() {
        ComponentAst errorAst = Utils.mockErrorAst("CUSTOM_ERROR", "OTHER_THAN_TEST_OR_MULE:PARENT");
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(errorAst);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("The error 'TEST:CUSTOM_ERROR' can't declare 'OTHER_THAN_TEST_OR_MULE:PARENT' as parent. It can only have a parent with namespace 'TEST' or 'MULE'");
        new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
    }

    @Test
    public void errorWithParentFromCore() {
        ComponentAst errorAst = Utils.mockErrorAst("CUSTOM_ERROR", "MULE:PARENT");
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(errorAst);
        Map errorParsersMap = new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
        ComponentIdentifier expectedErrorIdentifier = IdentifierParsingUtils.parseErrorType((String)"TEST:CUSTOM_ERROR", (String)TEST);
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.hasKey((Object)expectedErrorIdentifier));
        ErrorModelParser errorModelParser = (ErrorModelParser)errorParsersMap.get(expectedErrorIdentifier);
        Optional parentParser = errorModelParser.getParent();
        Assert.assertThat((Object)parentParser.isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((ErrorModelParser)parentParser.get()).getNamespace(), (Matcher)Matchers.is((Object)"MULE"));
        Assert.assertThat((Object)((ErrorModelParser)parentParser.get()).getType(), (Matcher)Matchers.is((Object)"PARENT"));
    }

    @Test
    public void errorWithParentFromSameExtension() {
        ComponentAst parentErrorAst = Utils.mockErrorAst("PARENT", null);
        ComponentAst childErrorAst = Utils.mockErrorAst("CHILD", "PARENT");
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(childErrorAst, parentErrorAst);
        Map errorParsersMap = new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
        ComponentIdentifier parentErrorId = IdentifierParsingUtils.parseErrorType((String)"TEST:PARENT", (String)TEST);
        ComponentIdentifier childErrorId = IdentifierParsingUtils.parseErrorType((String)"TEST:CHILD", (String)TEST);
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.hasKey((Object)parentErrorId));
        Assert.assertThat((Object)errorParsersMap, (Matcher)Matchers.hasKey((Object)childErrorId));
        ErrorModelParser childParser = (ErrorModelParser)errorParsersMap.get(childErrorId);
        ErrorModelParser parentParser = (ErrorModelParser)errorParsersMap.get(parentErrorId);
        Assert.assertThat((Object)((ErrorModelParser)childParser.getParent().get()), (Matcher)Matchers.is((Object)parentParser));
    }

    @Test
    public void circularDependency() {
        ComponentAst aAst = Utils.mockErrorAst("A", "B");
        ComponentAst bAst = Utils.mockErrorAst("B", "A");
        ArtifactAst extensionAst = MuleSdkErrorsDeclarationParserTestCase.mockExtensionAstWithErrors(aAst, bAst);
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Error while trying to parse the errors hierarchy, maybe there is a cycle");
        new MuleSdkErrorsDeclarationParser(extensionAst, TEST).parse();
    }

    private static ArtifactAst mockExtensionAstWithErrors(ComponentAst ... errorsAsts) {
        ArtifactAst extensionAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        ComponentAst someOtherComponentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)someOtherComponentAst.getIdentifier()).thenReturn((Object)TEST_COMPONENT_IDENTIFIER);
        ComponentAst errorsComponentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)errorsComponentAst.getIdentifier()).thenReturn((Object)MuleSdkDslConstants.MULE_SDK_EXTENSION_DSL_ERRORS_CONSTRUCT_IDENTIFIER);
        Mockito.when((Object)errorsComponentAst.directChildrenStreamByIdentifier("extension", "error")).thenReturn(Stream.of(errorsAsts));
        Assert.assertThat((Object)errorsComponentAst.getIdentifier().equals(someOtherComponentAst.getIdentifier()), (Matcher)Matchers.is((Object)false));
        Mockito.when((Object)extensionAst.topLevelComponentsStream()).thenReturn(Stream.of(someOtherComponentAst, errorsComponentAst));
        return extensionAst;
    }
}

