/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.validation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Stories;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.mule.internal.validation.AbstractConfigFileValidationTestCase;

@Feature(value="Reuse")
@Stories(value={@Story(value="Operations"), @Story(value="Parameters")})
public class OptionalParameterValidationsTestCase
extends AbstractConfigFileValidationTestCase {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    @Description(value="Optional parameters can't declare an expression as defaultValue")
    public void optionalParameterDefaultValueCanNotBeAnExpression() throws Exception {
        this.expected.expect(ConfigurationException.class);
        this.expected.expectMessage("An expression was given for 'defaultValue' of the optional parameter 'someparam'");
        this.parseConfig("validation/optional-parameter-with-expression-default.xml");
    }

    @Test
    @Description(value="An operation with only optional parameters is legal")
    public void operationWithOnlyOptionalParametersIsLegal() throws Exception {
        this.parseConfig("validation/operation-with-only-optional-parameter.xml");
    }

    @Test
    @Description(value="An operation empty parameters tag is legal")
    public void operationWithEmptyParametersTagIsLegal() throws Exception {
        this.parseConfig("validation/operation-with-empty-parameters-tag.xml");
    }
}

