/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.mule.testing.processing.strategies.test.api.ExecutionThreadTracker;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;

@Feature(value="Reuse")
@Story(value="Operations")
public class MuleOperationProcessingStrategyTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private ExecutionThreadTracker executionThreadTracker;

    protected String getConfigFile() {
        return "mule-operation-processing-strategy-test-config.xml";
    }

    @Test
    @Description(value="Given a composed operation with only a BLOCKING child operation, and a CPU_LITE operation without callback, when they are executed in that order, the BLOCKING child execution thread is the same as the CPU_LITE")
    public void blockingOperationInsideBodyDoesNotJumpThreadAfterExecute() throws Exception {
        this.flowRunner("blockingFlow").run();
        Assert.assertThat((Object)this.executionPhaseForKey("Blocking child"), (Matcher)CoreMatchers.is((Object)this.executionPhaseForKey("After operation with one blocking child")));
    }

    @Test
    @Description(value="Given a CPU_LITE operation without callback, and a composed operation with only a BLOCKING child operation, when they are executed in that order, the BLOCKING child execution thread is other than the CPU_LITE")
    public void blockingOperationInsideBodyJumpsThreadBeforeExecute() throws Exception {
        this.flowRunner("blockingFlow").run();
        Assert.assertThat((Object)this.executionPhaseForKey("Blocking child"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)this.executionPhaseForKey("Before operation with one blocking child"))));
    }

    @Test
    @Description(value="Given a composed operation ended with a non-blocking operation that is completed in phase C and anotherCPU_LITE operation without completion callback that executes in the phase B, when they are executed in that orderthen the phases C and B are different")
    public void operationAfterANonBlockingOnlyComposedOperationRunsInDifferentPhases() throws Exception {
        this.flowRunner("nonBlockingFlow").run();
        Assert.assertThat((Object)this.executionPhaseForKey("After operation with one non-blocking child"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)this.completionPhaseForKey("Non-blocking child"))));
    }

    @Test
    @Description(value="Given a CPU_LITE operation without completion callback that executes in the phase A, and a composed operation ended with a non-blocking operation that is executed in phase B, when they are executed in that orderthen the phases A and B are the same")
    public void operationBeforeANonBlockingComposedOperationRunsInSameThread() throws Exception {
        this.flowRunner("blockingFlow").run();
        Assert.assertThat((Object)this.executionPhaseForKey("Blocking child"), (Matcher)CoreMatchers.is((Object)this.executionPhaseForKey("After operation with one blocking child")));
    }

    @Test
    public void blockingOperationInsideComposedBodyJumpsThreadBeforeExecute() throws Exception {
        this.flowRunner("blockingComposedFlow").run();
        Assert.assertThat((Object)this.executionPhaseForKey("Blocking child"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)this.executionPhaseForKey("Before operationWithOneBlockingAndOneCpuLiteChildren operation"))));
    }

    @Test
    public void operationAfterANonBlockingEndedComposedOperationRunsInDifferentPhases() throws Exception {
        this.flowRunner("nonBlockingComposedFlow").run();
        Assert.assertThat((Object)this.executionPhaseForKey("After operationWithOneCpuLiteAndOneNonBlockingChildren operation"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)this.completionPhaseForKey("Non-blocking child"))));
    }

    private Integer completionPhaseForKey(String key) {
        return this.executionThreadTracker.getCompletionThreadPhase(key);
    }

    private Integer executionPhaseForKey(String key) {
        return this.executionThreadTracker.getExecutionThreadPhase(key);
    }
}

