/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mockito.Mockito;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.Utils;

class MuleSdkParameterModelParserSdkBuilder {
    private final Set<ExtensionDeclarer> extensionDeclarers = new HashSet<ExtensionDeclarer>();
    private final String name;
    private String type;
    private Map<String, MetadataType> typeLoaderTypes;
    private ComponentAst deprecatedAst;

    public MuleSdkParameterModelParserSdkBuilder(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public MuleSdkParameterModelParserSdkBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public MuleSdkParameterModelParserSdkBuilder withTypeLoaderTypes(Map<String, MetadataType> typeLoaderTypes) {
        this.typeLoaderTypes = typeLoaderTypes;
        return this;
    }

    public MuleSdkParameterModelParserSdkBuilder withExtensionInContext(ExtensionDeclarer extensionDeclarer) {
        this.extensionDeclarers.add(extensionDeclarer);
        return this;
    }

    public MuleSdkParameterModelParserSdkBuilder withDeprecationModel(String since, String message, String toRemoveIn) {
        this.deprecatedAst = Utils.mockDeprecatedAst(since, message, toRemoveIn);
        return this;
    }

    public MuleSdkParameterModelParser build() {
        TypeLoader typeLoader = Utils.mockTypeLoader(this.typeLoaderTypes != null ? this.typeLoaderTypes : Collections.emptyMap());
        DefaultExtensionModelHelper extensionModelHelper = new DefaultExtensionModelHelper(this.loadExtensionModels());
        ComponentAst componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentParameterAst parameterNameAst = Utils.singleParameterAst(this.name);
        Mockito.when((Object)componentAst.getParameter("General", "name")).thenReturn((Object)parameterNameAst);
        ComponentParameterAst typeParameterAst = Utils.singleParameterAst(this.type);
        Mockito.when((Object)componentAst.getParameter("General", "type")).thenReturn((Object)typeParameterAst);
        if (this.deprecatedAst != null) {
            Utils.setMockAstChild(componentAst, "deprecated", this.deprecatedAst);
        }
        return new MuleSdkParameterModelParser(componentAst, typeLoader, (ExtensionModelHelper)extensionModelHelper);
    }

    private Set<ExtensionModel> loadExtensionModels() {
        if (this.extensionDeclarers.isEmpty()) {
            return Collections.emptySet();
        }
        return this.loadExtensionModels(this.createLoadingRequest());
    }

    private Set<ExtensionModel> loadExtensionModels(ExtensionModelLoadingRequest loadingRequest) {
        return this.extensionDeclarers.stream().map(declarer -> new ExtensionModelLoader((ExtensionDeclarer)declarer){
            final /* synthetic */ ExtensionDeclarer val$declarer;
            {
                this.val$declarer = extensionDeclarer;
            }

            public String getId() {
                return MuleSdkParameterModelParserSdkBuilder.class.getName() + "#" + ((ExtensionDeclaration)this.val$declarer.getDeclaration()).getName();
            }

            protected void declareExtension(ExtensionLoadingContext context) {
            }
        }.loadExtensionModel(declarer, loadingRequest)).collect(Collectors.toSet());
    }

    private ExtensionModelLoadingRequest createLoadingRequest() {
        return ExtensionModelLoadingRequest.builder((ClassLoader)MuleSdkParameterModelParserSdkBuilder.class.getClassLoader(), (DslResolvingContext)DslResolvingContext.nullDslResolvingContext()).build();
    }
}

